/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.TargetCommonInteractionForProgramCommand;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.MQResource;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class TargetMQInteractionsForProgramCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TargetMQInteractionsForProgramCommand.class.getPackage().getName());
    private Program program;
    private Transaction transaction;

    public TargetMQInteractionsForProgramCommand(Program aProgram) {
        this(aProgram, null);
    }

    public TargetMQInteractionsForProgramCommand(Program aProgram, Transaction transaction) {
        Debug.enter((Logger)logger, (String)TargetMQInteractionsForProgramCommand.class.getName(), (String)"TargetMQInteractionsForProgramCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.program = aProgram;
        this.transaction = transaction;
        this.setAsync(false);
        this.setDescription("MQ Interactions for " + aProgram);
        Debug.exit((Logger)logger, (String)TargetMQInteractionsForProgramCommand.class.getName(), (String)"TargetMQInteractionsForProgramCommand");
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)TargetMQInteractionsForProgramCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String applID = resultSet.getString(1);
        String verb = resultSet.getString(2).trim();
        String objectType = resultSet.getString(3);
        String objectID = resultSet.getString(4).trim();
        Region sourceRegion = ResourceFactory.getSingleton().getRegion(applID);
        MQResource object = ResourceFactory.getSingleton().getMQResource(objectType, objectID);
        Interaction interaction = new Interaction(sourceRegion, this.program, verb, object, sourceRegion);
        Debug.exit((Logger)logger, (String)TargetMQInteractionsForProgramCommand.class.getName(), (String)"processRow");
        return interaction;
    }

    public SelectionObject getSelectionObject() {
        String table = IAUtilities.getMQDataTableName();
        return TargetCommonInteractionForProgramCommand.getCommonSelectionObject(table, this.program, this.transaction);
    }
}

