/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.DB2Resource;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class TargetDB2InteractionsForProgramCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TargetDB2InteractionsForProgramCommand.class.getPackage().getName());
    private Program program;
    private Transaction transaction;

    public TargetDB2InteractionsForProgramCommand(Program aProgram, Transaction transaction) {
        Debug.enter((Logger)logger, (String)TargetDB2InteractionsForProgramCommand.class.getName(), (String)"TargetDB2InteractionsForProgramCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.program = aProgram;
        this.transaction = transaction;
        this.setAsync(false);
        this.setDescription("DB2 Interactions for " + aProgram);
        Debug.exit((Logger)logger, (String)TargetDB2InteractionsForProgramCommand.class.getName(), (String)"TargetDB2InteractionsForProgramCommand");
    }

    public TargetDB2InteractionsForProgramCommand(Program aProgram) {
        this(aProgram, null);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)TargetDB2InteractionsForProgramCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String applID = resultSet.getString(1);
        String objectType = resultSet.getString(2);
        String objectID = resultSet.getString(3).trim();
        String verb = resultSet.getString(4).trim();
        Region sourceRegion = ResourceFactory.getSingleton().getRegion(applID);
        DB2Resource object = ResourceFactory.getSingleton().getDB2Resource(objectType, objectID);
        Interaction interaction = new Interaction(sourceRegion, this.program, verb, object, sourceRegion);
        Debug.exit((Logger)logger, (String)TargetDB2InteractionsForProgramCommand.class.getName(), (String)"processRow");
        return interaction;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)TargetDB2InteractionsForProgramCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getDB2DataTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("RESTYPE", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("RESNAME", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("FUNCTION", table, ColumnReference.DataType.String, null);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.program.getName()}, QueryElement.Predicate.AND, false);
        if (this.transaction != null) {
            result.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.transaction.getName()}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)TargetDB2InteractionsForProgramCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

