/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class TargetCommonInteractionForProgramCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TargetCommonInteractionForProgramCommand.class.getPackage().getName());

    public Object processRow(ResultSet resultSet) throws SQLException {
        return null;
    }

    public SelectionObject getSelectionObject() {
        return null;
    }

    protected static SelectionObject getCommonSelectionObject(String table, Program program, Transaction transaction) {
        Debug.enter((Logger)logger, (String)TargetCommonInteractionForProgramCommand.class.getName(), (String)"getCommonSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("FUNCTION", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("TYPE", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("OBJECT", table, ColumnReference.DataType.String, null);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{program.getName()}, QueryElement.Predicate.AND, false);
        if (transaction != null) {
            result.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{transaction.getName()}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)TargetCommonInteractionForProgramCommand.class.getName(), (String)"getCommonSelectionObject");
        return result;
    }
}

