/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class ShowScannerCommandsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowScannerCommandsCommand.class.getPackage().getName());
    private Program program;
    private Resource dsn;
    private boolean deps;
    private boolean affs;

    public ShowScannerCommandsCommand(Program aProgram, Resource aDsn, boolean affs, boolean deps) {
        Debug.enter((Logger)logger, (String)ShowScannerCommandsCommand.class.getName(), (String)"ShowScannerCommandsCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.program = aProgram;
        this.dsn = aDsn;
        this.deps = deps;
        this.affs = affs;
        Debug.exit((Logger)logger, (String)ShowScannerCommandsCommand.class.getName(), (String)"ShowScannerCommandsCommand");
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        return null;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)ShowScannerCommandsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getScanDetailTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().addSelectionColumn("OFFSET", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("COMMAND", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("RESOURCE_TYPE", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.addOrderByCondition("OFFSET", table, Direction.ASC);
        selection.addOrderByCondition("COMMAND", table, Direction.ASC);
        selection.addOrderByCondition("RESOURCE_TYPE", table, Direction.ASC);
        selection.appendCondition("DSNAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.dsn.getName()}, QueryElement.Predicate.AND, false);
        selection.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.program.getName()}, QueryElement.Predicate.AND, false);
        if (this.affs) {
            selection.appendCondition("AFFINITY", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"Y"}, QueryElement.Predicate.AND, false);
        }
        if (this.deps) {
            selection.appendCondition("DEPENDENCY", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"Y"}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)ShowScannerCommandsCommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }
}

