/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class ResourceVisualizationByTransactionsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceVisualizationByTransactionsCommand.class.getPackage().getName());
    private Resource resource;

    public ResourceVisualizationByTransactionsCommand(Resource aResource) {
        this.resource = aResource;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        String applid = resultSet.getString(1);
        Region region = ResourceFactory.getSingleton().getRegion(applid);
        String transid = resultSet.getString(2);
        Transaction transaction = ResourceFactory.getSingleton().getTransaction(transid);
        String programName = resultSet.getString(3);
        Program program = ResourceFactory.getSingleton().getProgram(programName);
        Resource[] result = new Resource[]{region, transaction, program};
        return result;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationByTransactionsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCICSDataTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("TRANSID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("PROGRAM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (this.resource != null) {
            if (this.resource instanceof Region) {
                selection.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            } else if (this.resource instanceof Transaction) {
                selection.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            } else if (this.resource instanceof Program) {
                selection.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            }
        }
        if (IAUtilities.hasContent(collectionId)) {
            selection.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        selection.addOrderByCondition("APPLID", table, Direction.ASC);
        Debug.exit((Logger)logger, (String)ResourceVisualizationByTransactionsCommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }
}

