/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class ResourceVisualizationByTSCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceVisualizationByTSCommand.class.getPackage().getName());
    private Resource resource;
    private Mode mode;

    public ResourceVisualizationByTSCommand(Resource aResource, Mode mode) {
        this.resource = aResource;
        this.mode = mode;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Resource regionOrPlatform = null;
        if (this.mode.equals((Object)Mode.Regions)) {
            String applid = resultSet.getString(1).trim();
            regionOrPlatform = ResourceFactory.getSingleton().getRegion(applid);
        } else {
            String platformName = resultSet.getString(1).trim();
            regionOrPlatform = ResourceFactory.getSingleton().getPlatform(platformName);
        }
        String applName = resultSet.getString(2).trim();
        int applVer1 = 0;
        int applVer2 = 0;
        int applVer3 = 0;
        if (IAUtilities.hasContent(applName)) {
            applVer1 = resultSet.getInt(3);
            applVer2 = resultSet.getInt(4);
            applVer3 = resultSet.getInt(5);
        }
        TSApplication application = null;
        application = this.mode.equals((Object)Mode.Regions) ? ResourceFactory.getSingleton().getTSApplication(null, applName, applVer1, applVer2, applVer3) : ResourceFactory.getSingleton().getTSApplication((Platform)regionOrPlatform, applName, applVer1, applVer2, applVer3);
        String transid = resultSet.getString(6).trim();
        Transaction transaction = ResourceFactory.getSingleton().getTransaction(transid);
        String programName = resultSet.getString(7).trim();
        Program program = ResourceFactory.getSingleton().getProgram(programName);
        Resource[] result = new Resource[]{regionOrPlatform, application, transaction, program};
        return result;
    }

    private Selection createSelection(String table) {
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        if (this.mode.equals((Object)Mode.Regions)) {
            selection.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        } else {
            selection.getSelect().addSelectionColumn("PLATFORM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        }
        selection.getSelect().addSelectionColumn("APPL_NAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER1", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER2", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPL_VER3", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("TRANSID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("PROGRAM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (this.resource != null) {
            if (this.resource instanceof Region) {
                selection.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            } else if (this.resource instanceof Platform) {
                selection.appendCondition("PLATFORM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            } else if (this.resource instanceof TSApplication) {
                TSApplication application = (TSApplication)this.resource;
                selection.appendCondition("APPL_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{application.getName().trim()}, QueryElement.Predicate.AND, false);
                selection.appendCondition("APPL_VER1", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{application.getMajorVersion()}, QueryElement.Predicate.AND, false);
                selection.appendCondition("APPL_VER2", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{application.getMinorVersion()}, QueryElement.Predicate.AND, false);
                selection.appendCondition("APPL_VER3", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{application.getMicroVersion()}, QueryElement.Predicate.AND, false);
            } else if (this.resource instanceof Transaction) {
                selection.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            } else if (this.resource instanceof Program) {
                selection.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
            }
        }
        if (IAUtilities.hasContent(collectionId)) {
            selection.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        return selection;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)ResourceVisualizationByTSCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Selection selectionCics = this.createSelection(IAUtilities.getCICSDataTableName());
        Selection selectionDb2 = this.createSelection(IAUtilities.getDB2DataTableName());
        Selection selectionIms = this.createSelection(IAUtilities.getIMSDataTableName());
        Selection selectionMq = this.createSelection(IAUtilities.getMQDataTableName());
        Selection selectionNatural = this.createSelection(IAUtilities.getNaturalTableName());
        selectionMq.setUnion(selectionNatural, false);
        selectionIms.setUnion(selectionMq, false);
        selectionDb2.setUnion(selectionIms, false);
        selectionCics.setUnion(selectionDb2, false);
        if (this.mode.equals((Object)Mode.Regions)) {
            selectionNatural.addOrderByCondition("APPLID", IAUtilities.getNaturalTableName(), Direction.ASC);
        } else {
            selectionNatural.addOrderByCondition("PLATFORM", IAUtilities.getNaturalTableName(), Direction.ASC);
        }
        selectionNatural.addOrderByCondition("APPL_NAME", IAUtilities.getNaturalTableName(), Direction.ASC);
        selectionNatural.addOrderByCondition("APPL_VER1", IAUtilities.getNaturalTableName(), Direction.ASC);
        selectionNatural.addOrderByCondition("APPL_VER2", IAUtilities.getNaturalTableName(), Direction.ASC);
        selectionNatural.addOrderByCondition("APPL_VER3", IAUtilities.getNaturalTableName(), Direction.ASC);
        Debug.exit((Logger)logger, (String)ResourceVisualizationByTSCommand.class.getName(), (String)"getSelectionObject");
        return selectionCics;
    }

    public static enum Mode {
        Regions,
        Platforms;

    }
}

