/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class ResourceConnectionsInitialProgramsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceConnectionsInitialProgramsCommand.class.getPackage().getName());
    private Program program;
    private boolean regionSearch;
    private boolean platformSearch;
    private boolean applicationSearch;

    public ResourceConnectionsInitialProgramsCommand(Program program, boolean regionSearch, boolean platformSearch, boolean applicationSearch) {
        this.program = program;
        this.regionSearch = regionSearch;
        this.platformSearch = platformSearch;
        this.applicationSearch = applicationSearch;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)ResourceConnectionsInitialProgramsCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int pos = 1;
        Region region = null;
        Platform platform = null;
        TSApplication application = null;
        if (this.regionSearch) {
            region = ResourceFactory.getSingleton().getRegion(resultSet.getString(pos++).trim());
        }
        if (this.platformSearch) {
            platform = ResourceFactory.getSingleton().getPlatform(resultSet.getString(pos++).trim());
        }
        if (this.applicationSearch) {
            String applName = resultSet.getString(pos++).trim();
            int ver1 = resultSet.getInt(pos++);
            int ver2 = resultSet.getInt(pos++);
            int ver3 = resultSet.getInt(pos++);
            application = ResourceFactory.getSingleton().getTSApplication(platform, applName, ver1, ver2, ver3);
        }
        Object[] row = new Object[]{region, platform, application};
        Debug.exit((Logger)logger, (String)ResourceConnectionsInitialProgramsCommand.class.getName(), (String)"processRow");
        return row;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)ResourceConnectionsInitialProgramsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCICSDataTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        if (this.regionSearch) {
            selection.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        }
        if (this.platformSearch && Version.getInstance().getDBVersion() >= 5200) {
            selection.getSelect().addSelectionColumn("PLATFORM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        }
        if (this.applicationSearch && Version.getInstance().getDBVersion() >= 5100) {
            selection.getSelect().addSelectionColumn("APPL_NAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            selection.getSelect().addSelectionColumn("APPL_VER1", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
            selection.getSelect().addSelectionColumn("APPL_VER2", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
            selection.getSelect().addSelectionColumn("APPL_VER3", table, ColumnReference.DataType.Integer, ColumnReference.Function.NONE);
        }
        if (IAUtilities.hasContent(collectionId)) {
            selection.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        selection.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.program.getName()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)ResourceConnectionsInitialProgramsCommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }
}

