/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.ia.commands.IQueryCommand;
import com.ibm.cics.ia.query.QueryResults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class QueryResultsCommand
extends Command
implements IQueryCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(QueryResultsCommand.class.getPackage().getName());
    private QueryResults queryResult;

    public QueryResultsCommand(QueryResults queryResult) {
        this.queryResult = queryResult;
    }

    public void start() {
        Debug.enter((Logger)logger, (String)QueryResultsCommand.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.getResults().addAll(this.queryResult.getInteractions());
        this.status = 1;
        Debug.exit((Logger)logger, (String)QueryResultsCommand.class.getName(), (String)"start");
    }

    @Override
    public Presentation getQuery() {
        return this.queryResult.getQuery();
    }

    @Override
    public String[] getColumns() {
        return this.queryResult.getUserColumnNames();
    }

    public List getGroupByColumns() {
        return new ArrayList<String>(Arrays.asList(this.queryResult.getColumnNames()));
    }
}

