/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.commands.CintPostRequest;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomFeed;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;

public class PropertiesForCintCollector {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PropertiesForCintCollector.class.getPackage().getName());
    private CintCollector cintCollector;
    private Map result;

    public PropertiesForCintCollector(CintCollector collector) {
        this.cintCollector = collector;
        this.result = null;
    }

    public void start() {
        Debug.enter((Logger)logger, (String)PropertiesForCintCollector.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        AtomContentElement element = this.cintCollector.getContentElement().getFirstElementByName("region");
        String applid = element.getAttribute("applid");
        String sysid = element.getAttribute("sysid");
        String connectionID = this.cintCollector.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        if (this.cintCollector.isConnectedToAtom()) {
            CintPostRequest collectorPostRequest = new CintPostRequest(MessageFormat.format(Messages.getString("IAOperationsView.statsCintRequestTask"), applid), applid, sysid, "STATS", connection);
            IStatus status = collectorPostRequest.run(null);
            AtomFeed feed = collectorPostRequest.getFeed();
            if (feed != null && feed.atomEntries != null && feed.atomEntries.size() > 0 && feed.atomEntries.get((int)0).atomContent instanceof CintCollector) {
                CintCollector collector = (CintCollector)feed.atomEntries.get((int)0).atomContent;
                element = collector.getContentElement().getFirstElementByName("region");
                this.result = element.getAttributes();
            }
        } else {
            WebServiceRequest collectorRequest = new WebServiceRequest(MessageFormat.format(Messages.getString("IAOperationsView.statsCintRequestTask"), applid), applid, sysid, "STATS", (IAtomConnection)connection);
            collectorRequest.schedule();
            try {
                collectorRequest.join();
            }
            catch (InterruptedException e) {
                Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"start", (Object)e);
            }
            List<AtomContent> atomContents = collectorRequest.getAtomContents();
            if (atomContents.size() > 0 && atomContents.get(0) instanceof CintCollector) {
                CintCollector collector = (CintCollector)atomContents.get(0);
                element = collector.getContentElement().getFirstElementByName("region");
                this.result = element.getAttributes();
            }
        }
        Debug.exit((Logger)logger, (String)PropertiesForCintCollector.class.getName(), (String)"start");
    }

    public Map getResult() {
        return this.result;
    }
}

