/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.commands.CincPostRequest;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.AtomContentElement;
import com.ibm.cics.ia.model.AtomFeed;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;

public class PropertiesForCincCollector {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PropertiesForCincCollector.class.getPackage().getName());
    private CincCollector cincCollector;
    private Map result;

    public PropertiesForCincCollector(CincCollector collector) {
        this.cincCollector = collector;
        this.result = null;
    }

    public void start() {
        Debug.enter((Logger)logger, (String)PropertiesForCincCollector.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String connectionID = this.cincCollector.getConnectionID();
        IConnection connection = AtomController.getInstance().getConnection(connectionID);
        if (this.cincCollector.isControllable()) {
            if (this.cincCollector.isConnectedToAtom()) {
                CincPostRequest collectorPostRequest = new CincPostRequest(Messages.getString("IAOperationsView.statsCincRequestTask"), "STAT", null, connection);
                IStatus status = collectorPostRequest.run(null);
                AtomFeed feed = collectorPostRequest.getFeed();
                if (feed != null && feed.atomEntries != null && feed.atomEntries.size() > 0) {
                    AtomContent atomContent = feed.atomEntries.get((int)0).atomContent;
                    AtomContentElement groupElement = this.cincCollector.getContentElement().getFirstElementByName("group");
                    AtomContentElement flowElement = atomContent.getContentElement().getFirstElementByName("flow");
                    HashMap<String, String[]> regionMap = new HashMap<String, String[]>();
                    if (flowElement != null) {
                        List<AtomContentElement> elements = flowElement.getChildElementsByName("cincstate");
                        int i = 0;
                        while (i < elements.size()) {
                            String applid = elements.get(i).getAttribute("app");
                            String sysid = elements.get(i).getAttribute("sysid");
                            String cf_total = elements.get(i).getAttribute("cf_total");
                            String curr_state = elements.get(i).getAttribute("curr_state");
                            String number = elements.get(i).getAttribute("number");
                            if (!applid.equals("")) {
                                regionMap.put(number, new String[]{applid, sysid, cf_total, curr_state});
                            }
                            ++i;
                        }
                        AtomContentElement element = flowElement.getFirstElementByName("availapps");
                        elements = element.getChildElementsByName("app");
                        for (AtomContentElement atomContentElement : elements) {
                            String applid = atomContentElement.getValue();
                            if (!IAUtilities.hasContent(applid)) continue;
                            String sysid = atomContentElement.getAttribute("sysid");
                            if (this.cincCollector.getMroRegions().containsKey(applid)) continue;
                            this.cincCollector.getMroRegions().put(applid, sysid);
                        }
                    }
                    this.result = new HashMap();
                    this.result.put("details", groupElement.getAttributes());
                    this.result.put("cincstate", regionMap);
                }
            } else {
                WebServiceRequest webServiceRequest = new WebServiceRequest(Messages.getString("IAOperationsView.statsCincRequestTask"), "STAT", null, (IAtomConnection)connection);
                webServiceRequest.schedule();
                try {
                    webServiceRequest.join();
                }
                catch (InterruptedException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"start", (Object)e);
                }
                List<AtomContent> atomContents = webServiceRequest.getAtomContents();
                if (atomContents.size() > 0) {
                    AtomContent atomContent = atomContents.get(0);
                    AtomContentElement groupElement = this.cincCollector.getContentElement().getFirstElementByName("group");
                    List<AtomContentElement> cincStateElements = atomContent.getContentElement().getFirstElementByName("group").getChildElementsByName("cincstate");
                    HashMap<String, String[]> regionMap = new HashMap<String, String[]>();
                    for (AtomContentElement cincStateElement : cincStateElements) {
                        String applid = cincStateElement.getAttribute("app");
                        if (applid.isEmpty()) continue;
                        String sysid = cincStateElement.getAttribute("sysid");
                        String cfTotal = cincStateElement.getAttribute("cf_total");
                        String currState = cincStateElement.getAttribute("curr_state");
                        String number = cincStateElement.getAttribute("number");
                        regionMap.put(number, new String[]{applid, sysid, cfTotal, currState});
                    }
                    AtomContentElement availAppsElement = groupElement.getFirstElementByName("availapps");
                    List<AtomContentElement> appElements = availAppsElement.getChildElementsByName("app");
                    for (AtomContentElement atomContentElement : appElements) {
                        String applid = atomContentElement.getValue();
                        if (!IAUtilities.hasContent(applid)) continue;
                        String sysid = atomContentElement.getAttribute("sysid");
                        if (this.cincCollector.getMroRegions().containsKey(applid)) continue;
                        this.cincCollector.getMroRegions().put(applid, sysid);
                    }
                    this.result = new HashMap();
                    this.result.put("details", groupElement.getAttributes());
                    this.result.put("cincstate", regionMap);
                }
            }
        } else if (this.cincCollector.isConnectedToAtom()) {
            CincPostRequest collectorPostRequest = new CincPostRequest(Messages.getString("IAOperationsView.statsCincRequestTask"), "ADMINDTL", this.cincCollector.getUserId(), connection);
            IStatus status = collectorPostRequest.run(null);
            AtomFeed feed = collectorPostRequest.getFeed();
            if (feed != null && feed.atomEntries != null && feed.atomEntries.size() > 0) {
                AtomContent atomContent = feed.atomEntries.get((int)0).atomContent;
                AtomContentElement detailsElement = atomContent.getContentElement().getFirstElementByName("details");
                Map<Object, Object> detailsMap = new HashMap();
                HashMap<String, String> applidMap = new HashMap<String, String>();
                if (detailsElement != null) {
                    detailsMap = detailsElement.getAttributes();
                    List<AtomContentElement> elements = atomContent.getContentElement().getChildElementsByName("applid");
                    int i = 0;
                    while (i < elements.size()) {
                        String number = elements.get(i).getAttribute("number");
                        String applid = elements.get(i).getAttribute("id");
                        applidMap.put(number, applid);
                        ++i;
                    }
                }
                this.result = new HashMap();
                this.result.put("details", detailsMap);
                this.result.put("applid", applidMap);
            }
        } else {
            WebServiceRequest webServiceRequest = new WebServiceRequest(Messages.getString("IAOperationsView.statsCincRequestTask"), "ADMINDTL", this.cincCollector.getUserId(), (IAtomConnection)connection);
            webServiceRequest.schedule();
            try {
                webServiceRequest.join();
            }
            catch (InterruptedException e) {
                Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"start", (Object)e);
            }
            List<AtomContent> atomContents = webServiceRequest.getAtomContents();
            if (atomContents.size() > 0) {
                AtomContent atomContent = atomContents.get(0);
                AtomContentElement detailsElement = atomContent.getContentElement().getFirstElementByName("details");
                Map<Object, Object> detailsMap = new HashMap();
                HashMap<String, String> applidMap = new HashMap<String, String>();
                if (detailsElement != null) {
                    detailsMap = detailsElement.getAttributes();
                    List<AtomContentElement> elements = atomContent.getContentElement().getChildElementsByName("applid");
                    int i = 0;
                    while (i < elements.size()) {
                        String number = elements.get(i).getAttribute("number");
                        String applid = elements.get(i).getAttribute("id");
                        applidMap.put(number, applid);
                        ++i;
                    }
                }
                this.result = new HashMap();
                this.result.put("details", detailsMap);
                this.result.put("applid", applidMap);
            }
        }
        Debug.exit((Logger)logger, (String)PropertiesForCincCollector.class.getName(), (String)"start");
    }

    public Map getResult() {
        return this.result;
    }
}

