/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class GetProgramFlowCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(GetProgramFlowCommand.class.getPackage().getName());
    private int rootTaskId;

    public GetProgramFlowCommand(int rootTaskId) {
        this.rootTaskId = rootTaskId;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Object id = resultSet.getObject(1);
        Object parentNodeId = resultSet.getObject(2);
        Object nodeName = resultSet.getObject(3);
        Object nodeType = resultSet.getObject(4);
        Object sourceFunction = resultSet.getObject(5);
        return new Object[]{id, parentNodeId, nodeName, nodeType, sourceFunction};
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getProgramFlowTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().addSelectionColumn("ID", table, ColumnReference.DataType.Integer, null);
        result.getSelect().addSelectionColumn("ID_PARENT_NODE", table, ColumnReference.DataType.Integer, null);
        result.getSelect().addSelectionColumn("NODE_NAME", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("NODE_TYPE", table, ColumnReference.DataType.String, null);
        result.getSelect().addSelectionColumn("SOURCE_FUNCTION", table, ColumnReference.DataType.String, null);
        result.appendCondition("ID_TASK_ROOT", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{this.rootTaskId}, QueryElement.Predicate.AND, false);
        result.addOrderByCondition("ID", table, Direction.ASC);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSelectionObject");
        return result;
    }
}

