/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindTransByCollectionCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindTransByCollectionCommand.class.getPackage().getName());

    public FindTransByCollectionCommand() {
        this.setDescription("Find Transactions by Collection ID");
    }

    public String processRow(ResultSet resultSet) throws SQLException {
        String transaction = resultSet.getString(1).trim();
        return transaction;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindTransByCollectionCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getResourcesTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("OBJECT", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (IAUtilities.hasContent(collectionIdByResource)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionIdByResource}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("TYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"TRANSID"}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)FindTransByCollectionCommand.class.getName(), (String)"getSelectionObject", (Object)("result: " + result.toString()));
        return result;
    }
}

