/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindScannerDataCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindScannerDataCommand.class.getPackage().getName());

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindScannerDataCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String dsnName = resultSet.getString(1);
        String programName = resultSet.getString(2);
        Program program = ResourceFactory.getSingleton().getProgram(programName);
        Resource dsn = ResourceFactory.getSingleton().getResource("DSNAME", dsnName);
        Resource[] result = new Resource[]{dsn, program};
        Debug.exit((Logger)logger, (String)FindScannerDataCommand.class.getName(), (String)"processRow");
        return result;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindScannerDataCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table1 = IAUtilities.getScanSummaryTableName();
        Selection selection1 = PresentationFactory.getInstance().createSelectForTable(table1, null);
        selection1.getSelect().addSelectionColumn("DSNAME", table1, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection1.getSelect().addSelectionColumn("PROGRAM", table1, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        String table2 = IAUtilities.getProgramInfoTableName();
        Selection selection2 = PresentationFactory.getInstance().createSelectForTable(table2, null);
        selection2.getSelect().addSelectionColumn("DSNAME", table2, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection2.getSelect().addSelectionColumn("PROGRAM", table2, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection2.addOrderByCondition("DSNAME", table2, Direction.ASC);
        selection1.setUnion(selection2, false);
        Debug.exit((Logger)logger, (String)FindScannerDataCommand.class.getName(), (String)"getSelectionObject");
        return selection1;
    }
}

