/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DBUtilities;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.IColumnResultsCommand;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.query.QueryResultRow;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class FindResourcesForApplicationCommand
extends IASQLCommand
implements IColumnResultsCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(SourceTable.class.getPackage().getName());
    public static final String ALL_RESOURCES_NAMED_APPLICATION = "RES";
    public static final String CICS_RESOURCES_NAMED_APPLICATION = "CICS";
    public static final String DB2_RESOURCES_NAMED_APPLICATION = "DB2";
    public static final String IMS_RESOURCES_NAMED_APPLICATION = "IMS";
    public static final String MQ_RESOURCES_NAMED_APPLICATION = "MQ";
    public static final String NATURAL_RESOURCES_NAMED_APPLICATION = "NAT";
    boolean storedProcedure = true;
    protected String[] columnArray = new String[]{"TYPE", "OBJECT"};
    protected Presentation presentation = null;
    protected SourceTable type = SourceTable.ALL;

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindResourcesForApplicationCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        QueryResultRow result = new QueryResultRow();
        Object[] rowData = new Object[this.columnArray.length];
        String type = "";
        String object = "";
        if (this.storedProcedure) {
            Map columns = null;
            try {
                columns = DBUtilities.getColumnsFromResultSet((ResultSet)resultSet);
            }
            catch (SQLException e) {
                Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"processRow", (Throwable)e, new HashMap());
            }
            if (columns != null) {
                if (columns.containsKey("TYPE")) {
                    int columnRef = (Integer)columns.get("TYPE");
                    type = resultSet.getString(columnRef).trim();
                }
                if (columns.containsKey("RESTYPE")) {
                    int columnRef = (Integer)columns.get("RESTYPE");
                    type = resultSet.getString(columnRef).trim();
                }
                if (columns.containsKey("OBJECT")) {
                    int columnRef = (Integer)columns.get("OBJECT");
                    object = resultSet.getString(columnRef).trim();
                }
                if (columns.containsKey("RESNAME")) {
                    int columnRef = (Integer)columns.get("RESNAME");
                    object = resultSet.getString(columnRef).trim();
                }
                Resource resource = ResourceFactory.getSingleton().getResource(type, object);
                rowData[0] = type;
                rowData[1] = resource;
            }
        }
        result.setData(rowData);
        Debug.exit((Logger)logger, (String)FindResourcesForApplicationCommand.class.getName(), (String)"processRow");
        return result;
    }

    @Override
    public String[] getColumns() {
        return this.columnArray;
    }

    public SourceTable getType() {
        return this.type;
    }

    public void setType(SourceTable type) {
        this.type = type;
    }

    public static enum SourceTable {
        ALL,
        CICS,
        IMS,
        MQ,
        DB2,
        NAT;


        public String getProcedureParameter() {
            Debug.enter((Logger)logger, (String)SourceTable.class.getName(), (String)"getProcedureParameter", (Object)("Thread ID: " + Thread.currentThread().getId()));
            String result = null;
            switch (this) {
                case ALL: {
                    result = FindResourcesForApplicationCommand.ALL_RESOURCES_NAMED_APPLICATION;
                    break;
                }
                case CICS: {
                    result = FindResourcesForApplicationCommand.CICS_RESOURCES_NAMED_APPLICATION;
                    break;
                }
                case IMS: {
                    result = FindResourcesForApplicationCommand.IMS_RESOURCES_NAMED_APPLICATION;
                    break;
                }
                case MQ: {
                    result = FindResourcesForApplicationCommand.MQ_RESOURCES_NAMED_APPLICATION;
                    break;
                }
                case DB2: {
                    result = FindResourcesForApplicationCommand.DB2_RESOURCES_NAMED_APPLICATION;
                    break;
                }
                case NAT: {
                    result = FindResourcesForApplicationCommand.NATURAL_RESOURCES_NAMED_APPLICATION;
                    break;
                }
                default: {
                    result = FindResourcesForApplicationCommand.ALL_RESOURCES_NAMED_APPLICATION;
                }
            }
            Debug.exit((Logger)logger, (String)SourceTable.class.getName(), (String)"getProcedureParameter");
            return result;
        }
    }
}

