/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindRegionsResourceCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindRegionsResourceCommand.class.getPackage().getName());

    public FindRegionsResourceCommand() {
        this.setDescription("Find Regions Resource");
    }

    public String processRow(ResultSet resultSet) throws SQLException {
        String regionID = resultSet.getString(1);
        return regionID;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindRegionsResourceCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getRegionInfoName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, null);
        Debug.exit((Logger)logger, (String)FindRegionsResourceCommand.class.getName(), (String)"getSelectionObject", (Object)("result: " + result.toString()));
        return result;
    }
}

