/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindRegionsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindRegionsCommand.class.getPackage().getName());
    private String searchMask;

    public FindRegionsCommand() {
        this.setDescription("Find Regions");
    }

    public void setRegionMask(String searchMask) {
        this.searchMask = searchMask;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        String regionID = resultSet.getString(1);
        Region region = ResourceFactory.getSingleton().getRegion(regionID);
        return region;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindRegionsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getRegionInfoName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", table, ColumnReference.DataType.String, null);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        if (IAUtilities.hasContent(this.searchMask)) {
            Comparator comparator = Comparator.LI;
            if (IAUtilities.isExactName(this.searchMask)) {
                comparator = Comparator.EQ;
            }
            result.appendCondition("APPLID", table, ColumnReference.DataType.String, comparator, new Object[]{this.searchMask}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)FindRegionsCommand.class.getName(), (String)"getSelectionObject", (Object)("result: " + result.toString()));
        return result;
    }
}

