/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindProgramsForRegionWithPresentationLogicCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindProgramsForRegionWithPresentationLogicCommand.class.getPackage().getName());
    private Region region;
    private String resourceType;

    public Object processRow(ResultSet resultSet) throws SQLException {
        return null;
    }

    public FindProgramsForRegionWithPresentationLogicCommand(Region region, String resourceType) {
        this.region = region;
        this.resourceType = resourceType;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindProgramsForRegionWithPresentationLogicCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCICSDataTableName();
        Selection result = PresentationFactory.getInstance().createSelectAllForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("PROGRAM", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.addOrderByCondition("PROGRAM", table, Direction.ASC);
        if (this.region != null) {
            result.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.region.getName()}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.IN, new Object[]{"ADDRESS", "ASSIGN", "CONVERSE", "DISCPSET", "EXTRACTC", "EXTRACTF", "EXTRACTS", "RECEIVE", "SEND"}, QueryElement.Predicate.AND, false);
        return result;
    }
}

