/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.DBUtilities;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.AbstractFindCICSObjectType;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPAPP;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class FindIAApplicationsCommand
extends AbstractFindCICSObjectType {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindIAApplicationsCommand.class.getPackage().getName());
    private boolean storedProcedure = false;
    private String searchMask;

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)FindIAApplicationsCommand.class.getName(), (String)"processRow");
        IAApplication iaApplication = null;
        String applicationID = null;
        String applicationName = null;
        if (this.storedProcedure) {
            Map columns = null;
            try {
                columns = DBUtilities.getColumnsFromResultSet((ResultSet)resultSet);
            }
            catch (SQLException e) {
                Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"processRow", (Throwable)e, new HashMap());
            }
            if (columns != null) {
                if (columns.containsKey("APPLIC_CODE")) {
                    int columnRef = (Integer)columns.get("APPLIC_CODE");
                    applicationID = resultSet.getString(columnRef).trim();
                }
                if (columns.containsKey("APPLIC_NAME")) {
                    int columnRef = (Integer)columns.get("APPLIC_NAME");
                    applicationName = resultSet.getString(columnRef).trim();
                }
                iaApplication = ResourceFactory.getSingleton().getIAApplication(applicationID, applicationName);
            }
        } else {
            applicationID = resultSet.getString(1).trim();
            applicationName = resultSet.getString(2).trim();
            iaApplication = ResourceFactory.getSingleton().getIAApplication(applicationID, applicationName);
        }
        Debug.exit((Logger)logger, (String)FindIAApplicationsCommand.class.getName(), (String)"processRow");
        return iaApplication;
    }

    @Override
    protected String getResourceType() {
        return "IA_APPLICATION";
    }

    @Override
    protected int getResourceNameSize() {
        return 8;
    }

    public void setApplicationMask(String searchMask) {
        this.searchMask = searchMask;
    }

    @Override
    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindIAApplicationsCommand.class.getName(), (String)"getSelectionObject");
        Selection result = null;
        if (DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").isProcedureAvailable((StoredProcedureDefinition)new ProcedureCIUSPAPP())) {
            this.storedProcedure = true;
            ProcedureCIUSPAPP sp = new ProcedureCIUSPAPP();
            String appCode = null;
            if (IAUtilities.hasContent(this.searchMask)) {
                appCode = IAUtilities.isExactName(this.searchMask) ? this.searchMask : IAUtilities.toLikeString(this.searchMask);
            }
            result = (Selection)sp.getSelectionObject("LIST", appCode, null);
        } else {
            String table = IAUtilities.getApplicationDescriptionTableName();
            result = PresentationFactory.getInstance().createSelectForTable(table, null);
            result.getSelect().setDistinct(true);
            result.getSelect().addSelectionColumn("APPLIC_CODE", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            result.getSelect().addSelectionColumn("APPLIC_NAME", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            if (IAUtilities.hasContent(this.searchMask)) {
                if (IAUtilities.isExactName(this.searchMask)) {
                    result.appendCondition("APPLIC_CODE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.searchMask}, QueryElement.Predicate.OR, false);
                } else {
                    result.appendCondition("APPLIC_CODE", table, ColumnReference.DataType.String, Comparator.LI, new Object[]{IAUtilities.toLikeString(this.searchMask)}, QueryElement.Predicate.OR, false);
                }
            }
        }
        Debug.exit((Logger)logger, (String)FindIAApplicationsCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

