/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class FindEventsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindEventsCommand.class.getPackage().getName());
    private Resource resource;

    public FindEventsCommand(Resource resource) {
        this.resource = resource;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindEventsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap map = new HashMap();
        String eventViewName = IAUtilities.getEventsView();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(eventViewName, null);
        selection.getSelect().addSelectionColumn("EVENT_NAME", eventViewName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("EVENT_CAPTURE_SPEC", eventViewName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("EVENT_BINDING", eventViewName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("FUNCTION", eventViewName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().setDistinct(true);
        selection.appendCondition("TYPE", eventViewName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getTypeName()}, QueryElement.Predicate.AND, false);
        selection.appendCondition("OBJECT", eventViewName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)FindEventsCommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        return new String[]{resultSet.getString(1).trim(), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim()};
    }
}

