/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class FindCollectionsByRegionCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindCollectionsByRegionCommand.class.getPackage().getName());

    public FindCollectionsByRegionCommand() {
        this.setDescription("Find Collection IDs by Region");
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        String collectionId = resultSet.getString(1).trim();
        return collectionId;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindCollectionsByRegionCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getRegionInfoName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("COLLECTION_ID", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (IAUtilities.hasContent(region)) {
            result.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{region}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)FindCollectionsByRegionCommand.class.getName(), (String)"getSelectionObject", (Object)("result: " + result.toString()));
        return result;
    }
}

