/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.IAffinityBuilderInputGroup;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FindAffGroupsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindAffGroupsCommand.class.getPackage().getName());
    private Region region;
    private Resource resource;
    private String groupType;

    public FindAffGroupsCommand(Region aRegion, Resource aResource, String aGroupType) {
        this.region = aRegion;
        this.resource = aResource;
        this.groupType = aGroupType;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        Object tranGroup = null;
        String applid = resultSet.getString(1);
        String trangroup = resultSet.getString(2);
        String affType = resultSet.getString(3);
        String groupType = resultSet.getString(4);
        String affinity = resultSet.getString(5);
        String affWorsened = resultSet.getString(6);
        String lifetime = resultSet.getString(7);
        String lifeWorsened = resultSet.getString(8);
        String recovery = resultSet.getString(9);
        String resource = resultSet.getString(10);
        String affGrpType = resultSet.getString(11);
        String affGrpTranCount = resultSet.getString(12);
        String affGrpProgCount = resultSet.getString(13);
        String affGrpBuild = resultSet.getString(14);
        values.put("APPLID", applid == null ? "" : applid.trim());
        values.put("TRANGROUP", trangroup == null ? "" : trangroup.trim());
        values.put("AFFTYPE", affType == null ? "" : affType.trim());
        values.put("GROUPTYPE", groupType == null ? "" : groupType.trim());
        values.put("AFFINITY", affinity == null ? "" : affinity.trim());
        values.put("AFFWORSENED", affWorsened == null ? "" : affWorsened.trim());
        values.put("LIFETIME", lifetime == null ? "" : lifetime.trim());
        values.put("LIFEWORSENED", lifeWorsened == null ? "" : lifeWorsened.trim());
        values.put("RECOVERY", recovery == null ? "" : recovery.trim());
        values.put("RESOURCE", resource == null ? "" : resource.trim());
        values.put("TYPE", affGrpType == null ? "" : affGrpType.trim());
        values.put("TRANCOUNT", affGrpTranCount == null ? "" : affGrpTranCount.trim());
        values.put("PROGCOUNT", affGrpProgCount == null ? "" : affGrpProgCount.trim());
        values.put("BUILD", affGrpBuild == null ? "" : affGrpBuild.trim());
        Debug.event((Logger)logger, (Level)Level.FINEST, (String)FindAffGroupsCommand.class.getName(), (String)"processRow", (Object)values.toString());
        if (trangroup != null) {
            IAffinityBuilderInputGroup affGroup = ResourceFactory.getSingleton().getAffGroup(trangroup, values);
            return affGroup;
        }
        return null;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindAffGroupsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String affGroupsTableName = IAUtilities.getAffinityGroupDataTableName();
        String affCommandsTableName = IAUtilities.getAffinityCommandTableName();
        Selection result = this.resource == null ? PresentationFactory.getInstance().createSelectForTable(affGroupsTableName, null) : PresentationFactory.getInstance().createSelectForTable(new String[]{affGroupsTableName, affCommandsTableName}, new String[2]);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TRANGROUP", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("AFFTYPE", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("GROUPTYPE", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("AFFINITY", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("AFFWORSENED", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("LIFETIME", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("LIFEWORSENED", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("RECOVERY", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("RESOURCE", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TYPE", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TRANCOUNT", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("PROGCOUNT", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("BUILD", affGroupsTableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.appendCondition("GROUPTYPE", affGroupsTableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.groupType}, QueryElement.Predicate.AND, false);
        if (this.region != null) {
            result.appendCondition("APPLID", affGroupsTableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.region.getName()}, QueryElement.Predicate.AND, false);
        }
        if (this.resource != null && this.resource.getTypeName() == "PROGRAM") {
            result = this.extendSelectionObject(result, affGroupsTableName, affCommandsTableName, "PROGRAM");
        }
        if (this.resource != null && this.resource.getTypeName() == "TRANSID") {
            result = this.extendSelectionObject(result, affGroupsTableName, affCommandsTableName, "TRANSID");
        }
        Debug.exit((Logger)logger, (String)FindAffGroupsCommand.class.getName(), (String)"getSelectionObject", (Object)("result: " + result));
        return result;
    }

    private Selection extendSelectionObject(Selection result, String affGroupsTableName, String affCommandsTableName, String type) {
        Debug.enter((Logger)logger, (String)FindAffGroupsCommand.class.getName(), (String)"extendSelectionObject", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "affGroupsTableName: " + affGroupsTableName, "affCommandsTableName" + affCommandsTableName, "type: " + type});
        Object[] values = new Object[]{PresentationFactory.getInstance().createBasicColumn("AFFGROUP", affCommandsTableName, ColumnReference.DataType.String)};
        result.appendCondition("TRANGROUP", affGroupsTableName, ColumnReference.DataType.String, Comparator.EQ, values, QueryElement.Predicate.AND, false);
        result.appendCondition(type, affCommandsTableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resource.getName()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)FindAffGroupsCommand.class.getName(), (String)"extendSelectionObject", (Object)("result: " + result));
        return result;
    }
}

