/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.AffCommand;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FindAffCommandsCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FindAffCommandsCommand.class.getPackage().getName());
    private AffGroup affGroup;

    public FindAffCommandsCommand(AffGroup anAffGroup) {
        this.affGroup = anAffGroup;
        this.setAsync(false);
    }

    public FindAffCommandsCommand() {
        this.affGroup = null;
        this.setAsync(false);
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        String applid = resultSet.getString(1);
        String transid = resultSet.getString(2);
        String program = resultSet.getString(3);
        String offset = resultSet.getString(4);
        String affCmdCommand = resultSet.getString(5);
        String affCmdResType = resultSet.getString(6);
        String affCmdAffGroup = resultSet.getString(7);
        String affCmdTerminal = resultSet.getString(8);
        String affCmdBTS = resultSet.getString(9);
        String affCmdLINK3270 = resultSet.getString(10);
        String affCmdUsage = resultSet.getString(11);
        values.put("APPLID", applid == null ? "" : applid.trim());
        values.put("TRANSID", transid == null ? "" : transid.trim());
        values.put("PROGRAM", program == null ? "" : program.trim());
        values.put("OFFSET", offset == null ? "" : offset.trim());
        values.put("COMMAND", affCmdCommand == null ? "" : affCmdCommand.trim());
        values.put("RESTYPE", affCmdResType == null ? "" : affCmdResType.trim());
        values.put("AFFGROUP", affCmdAffGroup == null ? "" : affCmdAffGroup.trim());
        values.put("TERMINAL", affCmdTerminal == null ? "" : affCmdTerminal.trim());
        values.put("BTS", affCmdBTS == null ? "" : affCmdBTS.trim());
        values.put("LINK3270", affCmdLINK3270 == null ? "" : affCmdLINK3270.trim());
        values.put("USAGE", affCmdUsage == null ? "" : affCmdUsage.trim());
        AffCommand affCommand = new AffCommand(this.affGroup, values);
        Debug.event((Logger)logger, (Level)Level.FINEST, (String)FindAffCommandsCommand.class.getName(), (String)"processRow", (Object)values.toString());
        return affCommand;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)FindAffCommandsCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String tableName = IAUtilities.getAffinityCommandTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(tableName, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("APPLID", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TRANSID", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("PROGRAM", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("OFFSET", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("COMMAND", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("RESTYPE", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("AFFGROUP", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("TERMINAL", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("BTS", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("LINK3270", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.getSelect().addSelectionColumn("USAGE", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        result.appendCondition("AFFGROUP", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.affGroup.getTranGroup()}, QueryElement.Predicate.AND, false);
        result.appendCondition("APPLID", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.affGroup.getRegionName()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)FindAffCommandsCommand.class.getName(), (String)"getSelectionObject", (Object)("result: " + result));
        return result;
    }
}

