/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Event;
import com.ibm.cics.ia.model.EventPropertySource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class EventPropertiesCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(EventPropertiesCommand.class.getPackage().getName());
    private Event event;

    public EventPropertiesCommand(Event event) {
        this.event = event;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)EventPropertiesCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap map = new HashMap();
        String table = IAUtilities.getEventPropertyTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        selection.appendCondition("EVENT_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.event.getName()}, QueryElement.Predicate.AND, false);
        selection.appendCondition("CAPTURE_SPEC", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.event.getCaptureSpec()}, QueryElement.Predicate.AND, false);
        selection.appendCondition("EVENT_BINDING", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.event.getBinding()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)EventPropertiesCommand.class.getName(), (String)"getSelectionObject");
        return selection;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)EventPropertiesCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap<String, String> columnToValue = new HashMap<String, String>();
        int i = 1;
        while (i <= EventPropertySource.getPropertyCount()) {
            String str = resultSet.getString(i);
            columnToValue.put(resultSet.getMetaData().getColumnName(i), str == null ? "" : str.trim());
            ++i;
        }
        Debug.exit((Logger)logger, (String)EventPropertiesCommand.class.getName(), (String)"processRow");
        return columnToValue;
    }
}

