/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class DistributedUOWForTaskCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DistributedUOWForTaskCommand.class.getPackage().getName());
    private Task task;

    public DistributedUOWForTaskCommand(Task task) {
        this.task = task;
        this.setAsync(false);
        this.setDescription("Command execution for " + task.getTaskID());
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)DistributedUOWForTaskCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean i = true;
        String distributedUOW = resultSet.getString(1);
        Debug.exit((Logger)logger, (String)DistributedUOWForTaskCommand.class.getName(), (String)"processRow");
        return distributedUOW;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)DistributedUOWForTaskCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCommandFlowTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.getSelect().addSelectionColumn("DISTRIBUTED_UOW", table, ColumnReference.DataType.String, null);
        result.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.task.getTransaction().getName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("TASKID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.task.getTaskID()}, QueryElement.Predicate.AND, false);
        result.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"START OF TRANSACTION"}, QueryElement.Predicate.AND, false);
        result.firstRowOnly();
        Debug.exit((Logger)logger, (String)DistributedUOWForTaskCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }

    public static String[] getColumns() {
        return SQLDefinitions.CMDFLOW_ATTRIBUTES.getAdjustedAttributes();
    }
}

