/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.CommandExecutionForTaskCommand;
import com.ibm.cics.ia.commands.ICommandFlowAnalyzer;
import com.ibm.cics.ia.commands.Messages;
import com.ibm.cics.ia.model.CommandExecution;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.CommandNode;
import com.ibm.cics.ia.model.viz.IConnectionsAnalyzerListener;
import com.ibm.cics.ia.model.viz.NestedNode;
import com.ibm.cics.ia.model.viz.Node;
import com.ibm.cics.ia.model.viz.NodeConnection;
import com.ibm.cics.ia.model.viz.RootNode;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CommandFlowTCBSwitchAnalyzer
extends Job
implements ICommandFlowAnalyzer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CommandFlowTCBSwitchAnalyzer.class.getPackage().getName());
    RootNode rootNode;
    LinkedList<IConnectionsAnalyzerListener> listeners = new LinkedList();
    private String taskName;
    private boolean cancelled = false;
    private boolean groupByRegions = false;
    private boolean groupByApplications = false;
    private Transaction transaction;
    private Task task;

    public CommandFlowTCBSwitchAnalyzer(Transaction transaction, Task task) {
        super(MessageFormat.format(Messages.getString("CommandFlowTCBSwitchAnalyzer.taskName.text"), task.getName()));
        this.rootNode = new RootNode();
        this.rootNode.setObject("TimelineFigure.Column.TCB");
        this.task = task;
        this.transaction = transaction;
    }

    @Override
    public void start() {
        Debug.enter((Logger)logger, (String)CommandFlowTCBSwitchAnalyzer.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CommandExecutionForTaskCommand command = new CommandExecutionForTaskCommand(this.task);
        command.setAsync(false);
        command.start();
        List results = command.getResults();
        this.analyzeConnections(results);
        this.notifyListeners();
        Debug.exit((Logger)logger, (String)CommandFlowTCBSwitchAnalyzer.class.getName(), (String)"start");
    }

    @Override
    public RootNode getRootNode() {
        return this.rootNode;
    }

    private void analyzeConnections(List results) {
        Debug.enter((Logger)logger, (String)CommandFlowTCBSwitchAnalyzer.class.getName(), (String)"analyzeConnections", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Node previousNode = null;
        Integer programCounter = 0;
        Integer commandCounter = 0;
        Program previousProgram = null;
        NestedNode<Program> programNode = null;
        for (CommandExecution commandExecution : results) {
            CommandExecution previousExecution;
            if (!commandExecution.getProgram().equals(previousProgram)) {
                programCounter = programCounter + 1;
                programNode = new NestedNode<Program>();
                programNode.setObject(commandExecution.getProgram());
                this.rootNode.getChildren().put(programCounter, programNode);
                previousProgram = commandExecution.getProgram();
            }
            commandCounter = commandCounter + 1;
            CommandNode commandNode = new CommandNode();
            commandNode.setObject(commandExecution);
            if (commandExecution.getResourceAndVerb().getVerb().equals("START OF TRANSACTION")) {
                commandExecution.getResourceAndVerb().setResource(ResourceFactory.getSingleton().getTransaction(commandExecution.get("TRANSID")));
            }
            commandNode.setParent(programNode);
            commandNode.setTimeLineRowObject(commandExecution.getTCBMode());
            programNode.getChildren().put(commandCounter, commandNode);
            commandNode.getCommandExecutions().add(commandExecution);
            if (previousNode != null && !(previousExecution = (CommandExecution)previousNode.getObject()).getTCBMode().equals(commandExecution.getTCBMode())) {
                NodeConnection nodeConnection = new NodeConnection(previousNode, commandNode);
                previousNode.getOutgoingConnections().add(nodeConnection);
                commandNode.getIncomingConnections().add(nodeConnection);
            }
            previousNode = commandNode;
        }
        Debug.exit((Logger)logger, (String)CommandFlowTCBSwitchAnalyzer.class.getName(), (String)"analyzeConnections", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    protected IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)CommandFlowTCBSwitchAnalyzer.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        monitor.beginTask(this.taskName, -1);
        this.start();
        monitor.done();
        Debug.exit((Logger)logger, (String)CommandFlowTCBSwitchAnalyzer.class.getName(), (String)"run");
        return Status.OK_STATUS;
    }

    protected void canceling() {
        this.cancelled = true;
        super.canceling();
    }

    @Override
    public void addListener(IConnectionsAnalyzerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IConnectionsAnalyzerListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        Debug.enter((Logger)logger, (String)CommandFlowTCBSwitchAnalyzer.class.getName(), (String)"notifyListeners", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (IConnectionsAnalyzerListener listener : this.listeners) {
            listener.onRootNodeUpdated(this.rootNode);
        }
        Debug.exit((Logger)logger, (String)CommandFlowTCBSwitchAnalyzer.class.getName(), (String)"notifyListeners");
    }
}

