/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.CSect;
import com.ibm.cics.ia.model.CSectPropertySource;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;

public class CSectPropertiesCommand
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CSectPropertiesCommand.class.getPackage().getName());
    private CSect csect;
    private int numberColumns;

    public CSectPropertiesCommand(CSect aCSect) {
        this.csect = aCSect;
        this.numberColumns = CSectPropertySource.getPropertyCount();
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)CSectPropertiesCommand.class.getName(), (String)"processRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap<String, String> properties = new HashMap<String, String>();
        int i = 1;
        while (i <= this.numberColumns) {
            properties.put(resultSet.getMetaData().getColumnName(i), resultSet.getString(i).trim());
            ++i;
        }
        Debug.exit((Logger)logger, (String)CSectPropertiesCommand.class.getName(), (String)"processRow");
        return properties;
    }

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)CSectPropertiesCommand.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String table = IAUtilities.getCSectInfoTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(table, null);
        result.appendCondition("DSNAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.csect.getDsn().getName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("PROGRAM", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.csect.getProgram().getName()}, QueryElement.Predicate.AND, false);
        result.appendCondition("CSECT_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.csect.getName()}, QueryElement.Predicate.AND, false);
        Debug.exit((Logger)logger, (String)CSectPropertiesCommand.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

