/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.commands;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.logging.Logger;

public abstract class AbstractFindCICSObjectType
extends IASQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AbstractFindCICSObjectType.class.getPackage().getName());
    protected String regionName = "";
    protected String resourceName = "";

    public SelectionObject getSelectionObject() {
        Debug.enter((Logger)logger, (String)AbstractFindCICSObjectType.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String tableName = IAUtilities.getResourcesTableName();
        Selection result = PresentationFactory.getInstance().createSelectForTable(tableName, null);
        result.getSelect().setDistinct(true);
        result.getSelect().addSelectionColumn("OBJECT", tableName, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        if (IAUtilities.hasContent(collectionId)) {
            result.appendCondition("COLLECTION_ID", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{collectionId}, QueryElement.Predicate.AND, false);
        }
        result.appendCondition("TYPE", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.getResourceType()}, QueryElement.Predicate.AND, false);
        if (IAUtilities.hasContent(this.regionName)) {
            if (IAUtilities.isExactName(this.regionName)) {
                result.appendCondition("APPLID", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.regionName}, QueryElement.Predicate.AND, false);
            } else {
                result.appendCondition("APPLID", tableName, ColumnReference.DataType.String, Comparator.LI, new Object[]{this.regionName}, QueryElement.Predicate.AND, false);
            }
        }
        if (IAUtilities.hasContent(this.resourceName)) {
            if (IAUtilities.isExactName(this.regionName)) {
                result.appendCondition("OBJECT", tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.resourceName}, QueryElement.Predicate.AND, false);
            } else {
                result.appendCondition("OBJECT", tableName, ColumnReference.DataType.String, Comparator.LI, new Object[]{this.resourceName}, QueryElement.Predicate.AND, false);
            }
        }
        Debug.exit((Logger)logger, (String)AbstractFindCICSObjectType.class.getName(), (String)"getSelectionObject", (Object)("result: " + result));
        return result;
    }

    public void setCriteriaName(String aRegionName) {
        Debug.enter((Logger)logger, (String)AbstractFindCICSObjectType.class.getName(), (String)"setCriteriaName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aRegionName: " + aRegionName});
        if (IAUtilities.hasContent(aRegionName)) {
            this.regionName = aRegionName;
        }
        Debug.exit((Logger)logger, (String)AbstractFindCICSObjectType.class.getName(), (String)"setCriteriaName");
    }

    public void setResourceName(String aResourceName) {
        Debug.enter((Logger)logger, (String)AbstractFindCICSObjectType.class.getName(), (String)"setResourceName", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aResourceName: " + aResourceName});
        if (IAUtilities.hasContent(aResourceName)) {
            this.resourceName = aResourceName;
        }
        Debug.exit((Logger)logger, (String)AbstractFindCICSObjectType.class.getName(), (String)"setResourceName");
    }

    protected abstract String getResourceType();

    protected abstract int getResourceNameSize();
}

