/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.preferences;

import com.ibm.systemz.wcaz4e.Activator;
import com.ibm.systemz.wcaz4e.preferences.IPreferenceConstants;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class PreferenceUtil
implements IPreferenceConstants {
    private static final String SECURITY_NODE_KEY = "com.ibm.systemz.wcaz4e.preferences.security";

    public static String getAuthenticationUrl() {
        return Activator.getInstance().getPreferenceStore().getString("com.ibm.systemz.wcaz4e.auth.url");
    }

    public static String getWcazUrl() {
        return Activator.getInstance().getPreferenceStore().getString("com.ibm.systemz.wcaz4e.wcaz.url");
    }

    public static int getRequestTimeoutMs() {
        return Activator.getInstance().getPreferenceStore().getInt("com.ibm.systemz.wcaz4e.timeout");
    }

    public static String getPlatform() {
        return Activator.getInstance().getPreferenceStore().getString("com.ibm.systemz.wcaz4e.platform");
    }

    public static boolean getStrictSSL() {
        return Activator.getInstance().getPreferenceStore().getBoolean("com.ibm.sysmtex.wcaz4e.strict.ssl");
    }

    public static boolean getOptInComments() {
        return Activator.getInstance().getPreferenceStore().getBoolean("com.ibm.systemz.wcaz4e.include.comments");
    }

    public static boolean getNativeLangExplanation() {
        return Activator.getInstance().getPreferenceStore().getBoolean("com.ibm.systemz.wcaz4e.include.native.lang.explanation");
    }

    public static char[] getUsername() {
        char[] charArray = null;
        try {
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences rootNode = preferences.node(SECURITY_NODE_KEY);
            byte[] byteArray = rootNode.getByteArray("com.ibm.systemz.wcaz4e.user.name", new byte[0]);
            if (byteArray != null && byteArray.length > 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
                CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
                charArray = new char[charBuffer.remaining()];
                charBuffer.get(charArray);
            }
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        return charArray;
    }

    public static char[] getApiKey() {
        char[] charArray = null;
        try {
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences rootNode = preferences.node(SECURITY_NODE_KEY);
            byte[] byteArray = rootNode.getByteArray("com.ibm.systemz.wcaz4e.api.key", new byte[0]);
            if (byteArray != null && byteArray.length > 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
                CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
                charArray = new char[charBuffer.remaining()];
                charBuffer.get(charArray);
            }
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        return charArray;
    }

    public static void setUsername(char[] apiKey) {
        try {
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences rootNode = preferences.node(SECURITY_NODE_KEY);
            if (apiKey != null && apiKey.length > 0) {
                CharBuffer charBuffer = CharBuffer.wrap(apiKey);
                ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
                byte[] byteArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byteArray);
                rootNode.putByteArray("com.ibm.systemz.wcaz4e.user.name", byteArray, true);
            } else {
                rootNode.remove("com.ibm.systemz.wcaz4e.user.name");
            }
            rootNode.flush();
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setApiKey(char[] apiKey) {
        try {
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences rootNode = preferences.node(SECURITY_NODE_KEY);
            if (apiKey != null && apiKey.length > 0) {
                CharBuffer charBuffer = CharBuffer.wrap(apiKey);
                ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
                byte[] byteArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byteArray);
                rootNode.putByteArray("com.ibm.systemz.wcaz4e.api.key", byteArray, true);
            } else {
                rootNode.remove("com.ibm.systemz.wcaz4e.api.key");
            }
            rootNode.flush();
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void clearApiKey(char[] apiKey) {
        if (apiKey != null && apiKey.length > 0) {
            int i = 0;
            while (i < apiKey.length) {
                apiKey[i] = 42;
                ++i;
            }
        }
    }

    public static boolean isApiKeyMissing() {
        boolean missingApiKey = false;
        char[] apiKey = PreferenceUtil.getApiKey();
        if (apiKey == null || apiKey.length == 0) {
            missingApiKey = true;
        }
        PreferenceUtil.clearApiKey(apiKey);
        return missingApiKey;
    }
}

