/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.preferences;

import com.ibm.systemz.wcaz4e.Activator;
import com.ibm.systemz.wcaz4e.Messages;
import com.ibm.systemz.wcaz4e.preferences.IPreferenceConstants;
import com.ibm.systemz.wcaz4e.preferences.PreferenceUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class GeneralPreferencePage
extends PreferencePage
implements IPreferenceConstants,
IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    public static final String copyright = "Licensed Materials - Property of IBM 5724T07 (C) Copyright IBM Corp. 2024 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Composite control;
    Button cloudPlatform;
    Button cpdPlatform;
    Text wcazUrl;
    Text apiKey;
    Text username;
    Text authenticationUrl;
    Button strictSSL;
    Button optInComments;
    Button nativeLangExplanation;
    Text timeout;

    public void init(IWorkbench arg0) {
        this.setPreferenceStore(Activator.getInstance().getPreferenceStore());
    }

    protected Control createContents(final Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(2, false));
        this.control.setLayoutData((Object)new GridData(770));
        Link link = new Link(this.control, 0);
        link.setText(Messages.GeneralPreferencePage_capabilitities_link);
        link.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.sdk.capabilities", null, null);
            }
        });
        GridData gd = new GridData(770);
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
        Group group = new Group(this.control, 0);
        group.setText(Messages.GeneralPreferencePage_platform_group);
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        Composite platform = new Composite((Composite)group, 0);
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        platform.setLayoutData((Object)gd);
        platform.setLayout((Layout)new GridLayout(1, false));
        this.cloudPlatform = new Button(platform, 16);
        this.cloudPlatform.setText("IBM Cloud");
        Activator.addAccessibilityData((Control)this.cloudPlatform, this.cloudPlatform.getText(), null);
        this.cpdPlatform = new Button(platform, 16);
        this.cpdPlatform.setText("IBM Cloud Pak for Data");
        Activator.addAccessibilityData((Control)this.cpdPlatform, this.cpdPlatform.getText(), null);
        Composite cpdSettings = new Composite(platform, 0);
        gd = new GridData(770);
        gd.horizontalSpan = 0;
        gd.horizontalIndent = 30;
        cpdSettings.setLayoutData((Object)gd);
        cpdSettings.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(cpdSettings, 0);
        label.setText(Messages.GeneralPreferencePage_cpd_username);
        label.setLayoutData((Object)new GridData());
        this.username = new Text(cpdSettings, 2052);
        gd = new GridData(768);
        gd.horizontalIndent = 10;
        this.username.setLayoutData((Object)gd);
        this.username.setEchoChar('*');
        Activator.addAccessibilityData((Control)this.username, label.getText(), null);
        this.strictSSL = new Button(cpdSettings, 32);
        this.strictSSL.setLayoutData((Object)new GridData());
        this.strictSSL.setText(Messages.GeneralPreferencePage_StrictSSL);
        Activator.addAccessibilityData((Control)this.strictSSL, label.getText(), null);
        gd = new GridData(0, 128, true, false);
        gd.horizontalIndent = 10;
        label = new Label(cpdSettings, 64);
        label.setText(Messages.GeneralPreferencePage_StrictSSL_desc);
        label.setLayoutData((Object)gd);
        group = new Group(this.control, 0);
        group.setText(Messages.GeneralPreferencePage_service_group);
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        label = new Label((Composite)group, 0);
        label.setText(Messages.GeneralPreferencePage_wcaz_url);
        label.setLayoutData((Object)new GridData());
        this.wcazUrl = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalIndent = 10;
        this.wcazUrl.setLayoutData((Object)gd);
        Activator.addAccessibilityData((Control)this.wcazUrl, label.getText(), null);
        Activator.addAccessibilityData((Control)this.wcazUrl, label.getText(), null);
        label = new Label((Composite)group, 0);
        label.setText(Messages.GeneralPreferencePage_timeout);
        label.setLayoutData((Object)new GridData());
        this.timeout = new Text((Composite)group, 2052);
        gd = new GridData(770);
        gd.horizontalIndent = 10;
        this.timeout.setLayoutData((Object)gd);
        this.timeout.addVerifyListener(e -> {
            String string = e.text;
            e.doit = string.matches("[\\d]*");
        });
        Activator.addAccessibilityData((Control)this.timeout, label.getText(), null);
        group = new Group(this.control, 0);
        group.setText(Messages.GeneralPreferencePage_iam_group);
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        label = new Label((Composite)group, 0);
        label.setText(Messages.GeneralPreferencePage_iam_url);
        label.setLayoutData((Object)new GridData());
        this.authenticationUrl = new Text((Composite)group, 2052);
        gd = new GridData();
        gd = new GridData(768);
        gd.horizontalIndent = 10;
        this.authenticationUrl.setLayoutData((Object)gd);
        Activator.addAccessibilityData((Control)this.authenticationUrl, label.getText(), null);
        label = new Label((Composite)group, 0);
        label.setText(Messages.GeneralPreferencePage_wcaz_apikey);
        label.setLayoutData((Object)new GridData());
        this.apiKey = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalIndent = 10;
        this.apiKey.setLayoutData((Object)gd);
        this.apiKey.setEchoChar('*');
        Activator.addAccessibilityData((Control)this.apiKey, label.getText(), null);
        group = new Group(this.control, 0);
        group.setText(Messages.GeneralPreferencePage_explanation_group);
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        this.optInComments = new Button((Composite)group, 32);
        GridData optInGd = new GridData();
        optInGd.horizontalSpan = 2;
        this.optInComments.setLayoutData((Object)optInGd);
        this.optInComments.setText(Messages.GeneralPreferencePage_OptInComments);
        Activator.addAccessibilityData((Control)this.optInComments, this.optInComments.getText(), null);
        this.nativeLangExplanation = new Button((Composite)group, 32);
        GridData nativeLangGrid = new GridData();
        nativeLangGrid.horizontalSpan = 2;
        this.nativeLangExplanation.setLayoutData((Object)nativeLangGrid);
        this.nativeLangExplanation.setText(Messages.GeneralPreferencePage_nativeLangExplanation);
        Activator.addAccessibilityData((Control)this.nativeLangExplanation, this.nativeLangExplanation.getText(), null);
        this.loadPreferences();
        this.cloudPlatform.addSelectionListener((SelectionListener)new EnablementListener("com.ibm.systemz.wcaz4e.platform"));
        this.cpdPlatform.addSelectionListener((SelectionListener)new EnablementListener("com.ibm.systemz.wcaz4e.platform"));
        this.authenticationUrl.addModifyListener((ModifyListener)this);
        this.wcazUrl.addModifyListener((ModifyListener)this);
        this.wcazUrl.addModifyListener((ModifyListener)new UrlModifyListener("com.ibm.systemz.wcaz4e.wcaz.url"));
        this.timeout.addModifyListener((ModifyListener)this);
        this.username.addModifyListener((ModifyListener)this);
        this.apiKey.addModifyListener((ModifyListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.systemz.wcaz4e.preferences.GeneralPreferencePage");
        return this.control;
    }

    private void updateValidation() {
        String errorMessage = null;
        String warningMessage = null;
        if (this.isEmpty(this.authenticationUrl)) {
            errorMessage = Messages.GeneralPreferencePage_error_missing_iam_url;
        } else if (!this.isUrl(this.authenticationUrl)) {
            errorMessage = Messages.GeneralPreferencePage_error_invalid_iam_url;
        } else if (this.isEmpty(this.wcazUrl)) {
            errorMessage = Messages.GeneralPreferencePage_error_missing_wcaz_url;
        } else if (!this.isUrl(this.wcazUrl)) {
            errorMessage = Messages.GeneralPreferencePage_error_invalid_wcaz_url;
        } else if (this.isEmpty(this.timeout)) {
            errorMessage = Messages.GeneralPreferencePage_error_missing_timeout;
        } else if (this.isEmpty(this.apiKey)) {
            warningMessage = Messages.GeneralPreferencePage_error_missing_apikey;
        } else if (this.isEmpty(this.username) && this.cpdPlatform.getSelection()) {
            warningMessage = Messages.GeneralPreferencePage_error_missing_username;
        }
        if (errorMessage == null) {
            try {
                int t = Integer.parseInt(this.timeout.getText());
                if (t <= 0) {
                    errorMessage = Messages.GeneralPreferencePage_error_invalid_timeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorMessage = Messages.GeneralPreferencePage_error_invalid_timeout;
            }
        }
        this.setValid(errorMessage == null);
        this.setErrorMessage(errorMessage);
        this.setMessage(warningMessage, 2);
    }

    private boolean isEmpty(Text text) {
        return text.getText() == null || text.getText().length() == 0;
    }

    private boolean isUrl(Text text) {
        String s = text.getText();
        if (s != null && s.length() > 0) {
            try {
                new URL(s);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void loadPreferences() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl23 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl23 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void savePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.cpdPlatform.getSelection()) {
            store.setValue("com.ibm.systemz.wcaz4e.platform", "IBM Cloud Pak for Data");
        } else {
            store.setValue("com.ibm.systemz.wcaz4e.platform", "IBM Cloud");
        }
        store.setValue("com.ibm.systemz.wcaz4e.wcaz.url", this.wcazUrl.getText());
        store.setValue("com.ibm.systemz.wcaz4e.auth.url", this.authenticationUrl.getText());
        store.setValue("com.ibm.sysmtex.wcaz4e.strict.ssl", this.strictSSL.getSelection());
        store.setValue("com.ibm.systemz.wcaz4e.timeout", Integer.parseInt(this.timeout.getText()));
        store.setValue("com.ibm.systemz.wcaz4e.include.comments", this.optInComments.getSelection());
        store.setValue("com.ibm.systemz.wcaz4e.include.native.lang.explanation", this.nativeLangExplanation.getSelection());
        PreferenceUtil.setUsername(this.username.getTextChars());
        PreferenceUtil.setApiKey(this.apiKey.getTextChars());
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean performOk() {
        this.savePreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.cloudPlatform.setSelection(true);
        this.cpdPlatform.setSelection(false);
        this.authenticationUrl.setText(store.getDefaultString("com.ibm.systemz.wcaz4e.auth.url"));
        this.wcazUrl.setText(store.getDefaultString("com.ibm.systemz.wcaz4e.wcaz.url"));
        this.username.setText(store.getDefaultString("com.ibm.systemz.wcaz4e.user.name"));
        this.apiKey.setText(store.getDefaultString("com.ibm.systemz.wcaz4e.api.key"));
        this.strictSSL.setSelection(true);
        this.optInComments.setSelection(false);
        this.nativeLangExplanation.setSelection(false);
        this.timeout.setText(store.getDefaultString("com.ibm.systemz.wcaz4e.timeout"));
    }

    public void dispose() {
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public void modifyText(ModifyEvent arg0) {
        this.updateValidation();
    }

    private void setEnabledWidgets(String text) {
        switch (text) {
            case "IBM Cloud": {
                this.authenticationUrl.setEnabled(true);
                this.authenticationUrl.setText("https://iam.cloud.ibm.com/identity/token");
                this.strictSSL.setEnabled(false);
                this.strictSSL.setSelection(true);
                this.username.setEnabled(false);
                break;
            }
            case "IBM Cloud Pak for Data": {
                this.authenticationUrl.setEnabled(false);
                this.authenticationUrl.setText((this.wcazUrl.getText() + "/icp4d-api").replaceAll("//", "/"));
                this.strictSSL.setEnabled(true);
                this.username.setEnabled(true);
            }
        }
    }

    private class EnablementListener
    implements SelectionListener {
        private String preferenceId;

        public EnablementListener(String preferenceId) {
            this.preferenceId = preferenceId;
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            Widget w = event.widget;
            if (w instanceof Button && this.preferenceId.equals("com.ibm.systemz.wcaz4e.platform")) {
                GeneralPreferencePage.this.setEnabledWidgets(((Button)w).getText());
            }
        }
    }

    private class UrlModifyListener
    implements ModifyListener {
        private String preferenceId;

        public UrlModifyListener(String preferenceId) {
            this.preferenceId = preferenceId;
        }

        public void modifyText(ModifyEvent arg0) {
            if (arg0.widget instanceof Text && this.preferenceId.equals("com.ibm.systemz.wcaz4e.wcaz.url") && GeneralPreferencePage.this.cpdPlatform.getSelection()) {
                GeneralPreferencePage.this.authenticationUrl.setText((GeneralPreferencePage.this.wcazUrl.getText() + "/icp4d-api").replaceAll("//", "/"));
            }
        }
    }
}

