/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.languages;

import com.ibm.systemz.wcaz4e.actions.Command;
import com.ibm.systemz.wcaz4e.extensions.IExplanationService;
import com.ibm.systemz.wcaz4e.preferences.PreferenceUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;

public class LanguageTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IFileEditorInput) {
            LANGUAGE[] lANGUAGEArray = LANGUAGE.values();
            int n = lANGUAGEArray.length;
            int n2 = 0;
            while (n2 < n) {
                LANGUAGE language = lANGUAGEArray[n2];
                if (language.getProperty().equals(property)) {
                    return LanguageTester.doesEditorInputSupportLanguage((IEditorInput)((IFileEditorInput)receiver), language);
                }
                ++n2;
            }
        }
        return false;
    }

    public static LANGUAGE getFileExtensionLanguage(String fileExtension) {
        LANGUAGE language = null;
        LANGUAGE[] lANGUAGEArray = LANGUAGE.values();
        int n = lANGUAGEArray.length;
        int n2 = 0;
        while (n2 < n) {
            LANGUAGE lang = lANGUAGEArray[n2];
            if (LanguageTester.fileExtensionMatchesLanguage(fileExtension, lang)) {
                language = lang;
                break;
            }
            ++n2;
        }
        return language;
    }

    public static String getEditorID(String fileExtension) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor[] availableEditors = editorRegistry.getEditors("ignore." + fileExtension.replaceAll("\\.", ""));
        LANGUAGE language = LanguageTester.getFileExtensionLanguage(fileExtension);
        IEditorDescriptor[] iEditorDescriptorArray = availableEditors;
        int n = availableEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editor = iEditorDescriptorArray[n2];
            if (editor.getId().equalsIgnoreCase(language.editorId)) {
                return language.editorId;
            }
            ++n2;
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public static boolean explorerSelectionEnabled(Object receiver) {
        if (receiver instanceof List && ((List)receiver).size() == 1) {
            IAdaptable adaptable = (IAdaptable)((List)receiver).get(0);
            IFile file = (IFile)adaptable.getAdapter(IFile.class);
            LANGUAGE language = LanguageTester.getFileExtensionLanguage(file.getFileExtension());
            if (language == LANGUAGE.HLASM && !LanguageTester.isSaasPlatformSelected()) {
                return false;
            }
            return LanguageTester.fileExtensionMatchesLanguage(file.getFileExtension(), language);
        }
        return false;
    }

    public static boolean isSimpleEnabled(Object receiver) {
        return LanguageTester.getSelectedFileLanguage(receiver) != null;
    }

    public static boolean isDetailedEnabled(Object receiver) {
        return LanguageTester.getSelectedFileLanguage(receiver) != null;
    }

    public static boolean isGuidedEnabled(Object receiver) {
        return LanguageTester.getSelectedFileLanguage(receiver) != null && (LanguageTester.getSelectedFileLanguage(receiver) == LANGUAGE.COBOL || LanguageTester.getSelectedFileLanguage(receiver) == LANGUAGE.PL1);
    }

    private static LANGUAGE getSelectedFileLanguage(Object receiver) {
        if (receiver instanceof List && ((List)receiver).size() == 1) {
            IAdaptable adaptable = (IAdaptable)((List)receiver).get(0);
            IFile file = (IFile)adaptable.getAdapter(IFile.class);
            return LanguageTester.getFileExtensionLanguage(file.getFileExtension());
        }
        return null;
    }

    public static boolean doesEditorInputSupportLanguage(IEditorInput editorInput, LANGUAGE language) {
        if (editorInput != null && language != null) {
            String fileName = LanguageTester.getFileName(editorInput);
            if (LanguageTester.doesFileNameMatchLanguageContentType(fileName, language)) {
                return true;
            }
            String extension = LanguageTester.getFileExtension(editorInput);
            String[] stringArray = language.fileExtensions;
            int n = language.fileExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext.equals(extension)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean doesFileNameSupportLangauge(String fileName, LANGUAGE language) {
        if (fileName != null && language != null) {
            if (LanguageTester.doesFileNameMatchLanguageContentType(fileName, language)) {
                return true;
            }
            String extension = LanguageTester.getFileExtension(fileName);
            String[] stringArray = language.fileExtensions;
            int n = language.fileExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext.equals(extension)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Set<Command> getActiveCommands(Object receiver) {
        Collection contextIds;
        IContextService service;
        IWorkbenchSite site;
        HashSet<Command> commands = new HashSet<Command>();
        if (receiver instanceof IWorkbenchSite && (site = (IWorkbenchSite)receiver) != null && (service = (IContextService)site.getService(IContextService.class)) != null && (contextIds = service.getActiveContextIds()) != null) {
            LANGUAGE[] lANGUAGEArray = LANGUAGE.values();
            int n = lANGUAGEArray.length;
            int n2 = 0;
            while (n2 < n) {
                LANGUAGE language = lANGUAGEArray[n2];
                if (contextIds.contains(language.getWcaz4eContextId())) {
                    commands.addAll(Arrays.asList(language.getExplainCommands()));
                }
                ++n2;
            }
        }
        return commands;
    }

    private static boolean doesFileNameMatchLanguageContentType(String fileName, LANGUAGE language) {
        if (fileName != null) {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            String[] stringArray = language.getContentTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentTypeId = stringArray[n2];
                IContentType contentType = contentTypeManager.getContentType(contentTypeId);
                if (contentType != null && contentType.isAssociatedWith(fileName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static String getFileName(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile().getName();
        }
        return editorInput.getName().trim();
    }

    private static String getFileExtension(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile().getFileExtension();
        }
        String fileName = LanguageTester.getFileName(editorInput);
        return LanguageTester.getFileExtension(fileName);
    }

    private static String getFileExtension(String fileName) {
        String[] split;
        if (fileName != null && (split = fileName.split("\\.")) != null && split.length > 0 && (split = split[split.length - 1].split(" ")) != null && split.length >= 0) {
            return split[0];
        }
        return null;
    }

    private static boolean fileExtensionMatchesLanguage(String fileExtension, LANGUAGE lanaguage) {
        String[] stringArray = lanaguage.fileExtensions;
        int n = lanaguage.fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (fileExtension.equalsIgnoreCase(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSaasPlatformSelected() {
        return !PreferenceUtil.getPlatform().equals("IBM Cloud Pak for Data");
    }

    public static enum LANGUAGE {
        COBOL("isCobol", new String[]{"com.ibm.ftt.language.cobol.core.CobolLanguage", "com.ibm.ftt.language.cobol.core.CobolCopybookLanguage"}, new String[]{"cbl", "ccp", "cob", "sqb", "cpy"}, "com.ibm.systemz.wcaz4e.cobol.context", "com.ibm.systemz.cobol.editor.jface.editor.CobolEditorID", new Command[]{Command.SIMPLE, Command.DETAILED, Command.GUIDED}, IExplanationService.LANGUAGE.COBOL),
        JCL("isJcl", new String[]{"com.ibm.ftt.language.jcl", "com.ibm.ftt.language.spool"}, new String[]{"jcl", "job", "prc", "spool"}, "com.ibm.systemz.wcaz4e.jcl.context", "com.ibm.systemz.jcl.editor.jface.editor.JclEditorID", new Command[]{Command.SIMPLE, Command.DETAILED}, IExplanationService.LANGUAGE.JCL),
        PL1("isPl1", new String[]{"com.ibm.ftt.language.pli.core.PliLanguage", "com.ibm.ftt.language.pli.core.PLIIncludeLanguage"}, new String[]{"pli", "pl1", "pc", "pci", "plinc", "pcx", "inc", "include"}, "com.ibm.systemz.wcaz4e.pl1.context", "com.ibm.systemz.pl1.editor.jface.editor.Pl1EditorID", new Command[]{Command.SIMPLE, Command.DETAILED, Command.GUIDED}, IExplanationService.LANGUAGE.PL1),
        REXX("isRexx", new String[]{"com.ibm.systemz.lsp.rexx.editor"}, new String[]{"rexx", "rex", "rexmac"}, "com.ibm.systemz.wcaz4e.rexx.context", "com.ibm.systemz.lsp.rexx.editor.RexxEditor", new Command[]{Command.SIMPLE, Command.DETAILED}, IExplanationService.LANGUAGE.REXX),
        HLASM("isHlasm", new String[]{"com.ibm.systemz.lsp.hlasm.editor"}, new String[]{"hlasm", "asm", "s", "mac", "hla"}, "com.ibm.systemz.wcaz4e.hlasm.context", "com.ibm.systemz.lsp.hlasm.editor", new Command[]{Command.SIMPLE, Command.DETAILED}, IExplanationService.LANGUAGE.HLASM);

        private String property;
        private String[] contentTypes;
        private String[] fileExtensions;
        private String wcaz4eContextId;
        private String editorId;
        private Command[] explainCommands;
        IExplanationService.LANGUAGE language;

        private LANGUAGE(String property, String[] contentTypes, String[] fileExtensions, String wcaz4eContextId, String editorId, Command[] explainCommands, IExplanationService.LANGUAGE language) {
            this.property = property;
            this.contentTypes = contentTypes;
            this.fileExtensions = fileExtensions;
            this.wcaz4eContextId = wcaz4eContextId;
            this.editorId = editorId;
            this.explainCommands = explainCommands;
            this.language = language;
        }

        public String getProperty() {
            return this.property;
        }

        public String[] getContentTypes() {
            return this.contentTypes;
        }

        public String[] getFileExtensions() {
            return this.fileExtensions;
        }

        public String getWcaz4eContextId() {
            return this.wcaz4eContextId;
        }

        public Command[] getExplainCommands() {
            return this.explainCommands;
        }

        public IExplanationService.LANGUAGE getExplanationServiceLanguage() {
            return this.language;
        }
    }
}

