/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.extensionpoint;

import com.ibm.systemz.wcaz4e.extensions.IExplanationInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorExplanationInput
implements IExplanationInput {
    private IEditorInput originatingEditorInput;
    private final String originatingEditorId;
    private IEditorInput sourceEditorInput;
    private String sourceText = null;
    private int sourceEndLine;
    private int sourceStartLine;

    public TextEditorExplanationInput(ITextEditor editorPart, ITextSelection selection) {
        IDocument document;
        this.originatingEditorInput = editorPart.getEditorInput();
        this.originatingEditorId = editorPart.getEditorSite().getId();
        this.sourceEditorInput = this.originatingEditorInput;
        this.sourceStartLine = selection.getStartLine();
        this.sourceEndLine = selection.getEndLine();
        this.sourceText = selection.getText();
        IDocumentProvider provider = editorPart.getDocumentProvider();
        if (provider != null && (document = provider.getDocument((Object)editorPart.getEditorInput())) != null) {
            if (selection.getLength() == 0) {
                selection = new TextSelection(document, 0, document.getLength());
            }
            try {
                this.sourceStartLine = Math.max(0, selection.getStartLine());
                this.sourceEndLine = Math.min(Math.max(0, selection.getEndLine()), document.getNumberOfLines());
                int newOffset = document.getLineOffset(this.sourceStartLine);
                int endOffset = document.getLineOffset(this.sourceEndLine) + document.getLineLength(this.sourceEndLine);
                this.sourceText = document.get(newOffset, endOffset - newOffset - 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public String getSourceFileName() {
        return this.sourceEditorInput.getName();
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public int getSourceStartLine() {
        return this.sourceStartLine;
    }

    public int getSourceEndLine() {
        return this.sourceEndLine;
    }

    public String getReferenceWord() {
        return null;
    }

    public String getReferenceWordType() {
        return null;
    }

    public void jumpToSourceLocation() {
        IEditorPart openEditor = null;
        if (this.originatingEditorInput != null) {
            openEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor(this.originatingEditorInput);
            try {
                if (openEditor == null) {
                    openEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(this.originatingEditorInput, this.originatingEditorId);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        if (openEditor != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)openEditor);
            if (openEditor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)openEditor;
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                try {
                    int offset = document.getLineOffset(this.sourceStartLine);
                    int endOffset = document.getLineOffset(this.sourceEndLine) + document.getLineLength(this.sourceEndLine);
                    textEditor.selectAndReveal(offset, endOffset - offset);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

