/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.extensionpoint;

import com.ibm.systemz.wcaz4e.Activator;
import com.ibm.systemz.wcaz4e.PartListener;
import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.extensionpoint.ExplanationService;
import com.ibm.systemz.wcaz4e.extensionpoint.ExplanationSourceDelegate;
import com.ibm.systemz.wcaz4e.extensionpoint.TextEditorExplanationSource;
import com.ibm.systemz.wcaz4e.extensions.IExplanationService;
import com.ibm.systemz.wcaz4e.extensions.IExplanationSource;
import com.ibm.systemz.wcaz4e.extensions.IExplanationSourceFactory;
import com.ibm.systemz.wcaz4e.languages.LanguageTester;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnableWithResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExtensionManager {
    private Set<Source> sources = new HashSet<Source>();
    private Set<String> allowedPartIds;
    Map<IWorkbenchPart, ExplanationSource[]> partToSourceMap = new HashMap<IWorkbenchPart, ExplanationSource[]>();

    public ExtensionManager() {
        IConfigurationElement[] extensionElements;
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensionElements = extReg.getConfigurationElementsFor("com.ibm.systemz.wcaz4e.extensions.explanationSource");
        int n = extensionElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extensionElement = iConfigurationElementArray[n2];
            this.sources.add(new Source(extensionElement));
            ++n2;
        }
        this.allowedPartIds = Set.of("org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.genericeditor.GenericEditor", "org.eclipse.ui.DefaultTextEditor", "editor.id.cobol", "editor.id.jcl", "editor.id.pl1", "editor.id.rexx", "editor.id.assembler", "com.ibm.systemz.jcl.editor.jface.editor.JclEditorID", "com.ibm.systemz.spool.editor.jface.editor.SpoolEditorID", "com.ibm.systemz.cobol.editor.jface.editor.CobolEditorID", "com.ibm.systemz.pl1.editor.jface.editor.Pl1EditorID", "com.ibm.systemz.lsp.rexx.editor", "com.ibm.systemz.lsp.rexx.editor.RexxEditor", "com.ibm.systemz.lsp.hlasm.editor", "com.ez.mainframe.editors.cobol.CobolEditor", "com.ez.mainframe.editors.jcl.JCLEditor", "com.ez.mainframe.editors.pl1.PL1Editor", "com.ez.mainframe.editors.assembler.AssemblerEditor");
        new PartListener(this);
    }

    public void loadExplanationSourcesForWorkbenchPart(IWorkbenchPart part) {
        if (part != null && part.getSite() != null && !this.partToSourceMap.containsKey(part) && this.allowedPartIds.contains(part.getSite().getId())) {
            ITextEditor textEditor;
            ArrayList<ExplanationSource> result = new ArrayList<ExplanationSource>();
            for (Source source : this.sources) {
                ExplanationSource explanationSource = source.getExplanationSource(part);
                if (explanationSource == null) continue;
                result.add(explanationSource);
            }
            if (part != null && part.toString().contains("com.ez.mainframe.editors")) {
                try {
                    textEditor = (ITextEditor)part;
                    TextEditorExplanationSource source = new TextEditorExplanationSource(textEditor);
                    ExplanationService service = new ExplanationService(part);
                    IExplanationService.LANGUAGE language = null;
                    String partName = part.toString().toLowerCase();
                    if (partName.contains("cobol")) {
                        language = IExplanationService.LANGUAGE.COBOL;
                    } else if (partName.contains("pl1")) {
                        language = IExplanationService.LANGUAGE.PL1;
                    } else if (partName.contains("jcl")) {
                        language = IExplanationService.LANGUAGE.JCL;
                    } else if (partName.contains("assembler")) {
                        language = IExplanationService.LANGUAGE.HLASM;
                    }
                    service.setExplanationLanguage(language);
                    result.add(new ExplanationSource(source, service));
                }
                catch (Exception e) {
                    Activator.logInfo("Exception occured while getting mainframe editor : " + e.getMessage());
                }
            }
            if (result.isEmpty() && part instanceof ITextEditor) {
                textEditor = (ITextEditor)part;
                LanguageTester.LANGUAGE[] lANGUAGEArray = LanguageTester.LANGUAGE.values();
                int n = lANGUAGEArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LanguageTester.LANGUAGE language = lANGUAGEArray[n2];
                    if (LanguageTester.doesEditorInputSupportLanguage(textEditor.getEditorInput(), language)) {
                        TextEditorExplanationSource source = new TextEditorExplanationSource(textEditor);
                        ExplanationService service = new ExplanationService(part);
                        service.setExplanationLanguage(language.getExplanationServiceLanguage());
                        result.add(new ExplanationSource(source, service));
                    }
                    ++n2;
                }
            }
            ExplanationSource[] array = result.toArray(new ExplanationSource[0]);
            this.partToSourceMap.put(part, array);
        }
    }

    public ExplanationSource[] getExplanationSourcesForWorkbenchPart(IWorkbenchPart part) {
        return this.partToSourceMap.get(part);
    }

    public void removeExplanationSourcesForWorkbenchPart(IWorkbenchPart part) {
        ExplanationSource[] sources = this.partToSourceMap.remove(part);
        if (sources != null) {
            ExplanationSource[] explanationSourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                ExplanationSource source = explanationSourceArray[n2];
                source.source.dispose();
                source.service.dispose();
                ++n2;
            }
        }
    }

    public class ExplanationSource {
        IExplanationSource source;
        ExplanationService service;

        public ExplanationSource(IExplanationSource source, ExplanationService service) {
            this.source = source;
            this.service = service;
        }

        public IExplanationSource getSource() {
            return this.source;
        }

        public ExplanationService getService() {
            return this.service;
        }
    }

    public static interface IErrorHandler {
        public void handleError(Throwable var1);
    }

    private class Source
    implements IErrorHandler {
        String extensionId;
        String name;
        Set<String> workbenchPartIds;
        IConfigurationElement extensionElement;
        IExplanationSourceFactory factory = null;
        boolean isValid = true;

        public Source(IConfigurationElement extensionElement) {
            this.extensionElement = extensionElement;
            this.extensionId = extensionElement.getNamespaceIdentifier();
            this.name = extensionElement.getAttribute("name");
            this.workbenchPartIds = new HashSet<String>();
            IConfigurationElement[] iConfigurationElementArray = extensionElement.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                if ("workbenchPart".equals(configElement.getName())) {
                    String workbenchPartId = configElement.getAttribute("id");
                    if (workbenchPartId != null) {
                        this.workbenchPartIds.add(workbenchPartId);
                    } else {
                        this.isValid = false;
                    }
                } else {
                    this.isValid = false;
                }
                ++n2;
            }
            if (this.workbenchPartIds.isEmpty()) {
                this.isValid = false;
            }
            Tracer.trace().trace("/debug/extension", this.toString());
        }

        public ExplanationSource getExplanationSource(final IWorkbenchPart part) {
            if (this.isValid && part != null && this.workbenchPartIds.contains(part.getSite().getId())) {
                try {
                    if (this.factory == null) {
                        Object o = this.extensionElement.createExecutableExtension("class");
                        if (o instanceof IExplanationSourceFactory) {
                            this.factory = (IExplanationSourceFactory)o;
                        } else if (o != null) {
                            Tracer.trace().trace("/debug/extension", String.valueOf(o.getClass()) + " not instance of IExplanationSourceFactory; " + this.toString());
                            this.isValid = false;
                        } else {
                            Tracer.trace().trace("/debug/extension", "Failed to create executable extension " + this.toString());
                            this.isValid = false;
                        }
                    }
                    if (this.factory != null) {
                        final ExplanationService service = new ExplanationService(part);
                        IExplanationSource source = (IExplanationSource)SafeRunner.run((ISafeRunnableWithResult)new ISafeRunnableWithResult<IExplanationSource>(){

                            public IExplanationSource runWithResult() throws Exception {
                                return Source.this.factory.getExplanationSource((Object)part, (IExplanationService)service);
                            }

                            public void handleException(Throwable exception) {
                                Source.this.handleError(exception);
                            }
                        });
                        if (source != null) {
                            return new ExplanationSource(new ExplanationSourceDelegate(source, this), service);
                        }
                        service.dispose();
                    }
                }
                catch (CoreException e) {
                    Tracer.trace().trace("/debug/extension", "Error instantiating " + this.toString(), (Throwable)e);
                    this.isValid = false;
                }
            }
            return null;
        }

        public String toString() {
            StringBuffer partBuffer = new StringBuffer();
            if (this.workbenchPartIds == null) {
                partBuffer.append("null");
            } else {
                for (String s : this.workbenchPartIds) {
                    partBuffer.append(s + "; ");
                }
            }
            return "Source [extensionId=" + this.extensionId + ", name=" + this.name + ", workbenchPartIds=" + partBuffer.toString() + ", isValid=" + this.isValid + "]";
        }

        @Override
        public void handleError(Throwable t) {
            Status error = new Status(4, "com.ibm.systemz.wcaz4e", t.getLocalizedMessage(), t);
            String title = "watsonx Code Assistant Extension Error";
            String message = MessageFormat.format("Explanation Source Extension ''{0}'' ({1}) threw the following error:", this.name, this.extensionId);
            ErrorDialog.openError((Shell)Activator.getDisplay().getActiveShell(), (String)title, (String)message, (IStatus)error);
            t.printStackTrace();
            Tracer.trace().trace("/debug/extension", message, t);
        }
    }
}

