/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.extensionpoint;

import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.extensions.IExplanationInput;
import com.ibm.systemz.wcaz4e.languages.LanguageTester;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ExplorerExplanationInput
implements IExplanationInput {
    private int sourceStartLine;
    private int sourceEndLine;
    private String sourceText = null;
    private IFile sourceFile = null;

    public ExplorerExplanationInput(IWorkbenchPart workbenchPart, ITreeSelection selection) {
        if (!(selection instanceof TreeSelection) || ((TreeSelection)selection).size() != 1) {
            return;
        }
        IAdaptable adaptable = (IAdaptable)((TreeSelection)selection).getFirstElement();
        this.sourceFile = (IFile)adaptable.getAdapter(IFile.class);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.sourceFile.getContents()));
            StringBuilder contents = new StringBuilder();
            int numLines = 0;
            while ((line = reader.readLine()) != null) {
                contents.append(line).append("\n");
                ++numLines;
            }
            int contentLength = 0;
            contentLength = contents.length();
            if (contentLength > 0) {
                contents.setLength(contentLength - 1);
            }
            this.sourceStartLine = 0;
            this.sourceEndLine = numLines - 1;
            this.sourceText = contents.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getSourceFileName() {
        if (this.sourceFile != null) {
            return this.sourceFile.getName();
        }
        return null;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public int getSourceStartLine() {
        return this.sourceStartLine;
    }

    public int getSourceEndLine() {
        return this.sourceEndLine;
    }

    public String getReferenceWord() {
        return null;
    }

    public String getReferenceWordType() {
        return null;
    }

    public void jumpToSourceLocation() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor((IEditorInput)new FileEditorInput(this.sourceFile), LanguageTester.getEditorID(this.sourceFile.getFileExtension()));
        }
        catch (Exception e) {
            Tracer.trace().trace("/debug/explanation", "Unable to resolve workspace folder (Unable to resolve nonexistent file) {0}\nCannot open file. Refresh IBM watsonx Code Assistant for Z", (Throwable)e);
        }
    }
}

