/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.extensionpoint;

import com.ibm.systemz.wcaz4e.extensionpoint.ExplanationInputDelegate;
import com.ibm.systemz.wcaz4e.extensionpoint.ExtensionManager;
import com.ibm.systemz.wcaz4e.extensions.IExplanationInput;
import com.ibm.systemz.wcaz4e.extensions.IExplanationLanguage;
import com.ibm.systemz.wcaz4e.extensions.IExplanationSource;
import org.eclipse.core.runtime.ISafeRunnableWithResult;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExplanationSourceDelegate
implements IExplanationSource {
    IExplanationSource source;
    ExtensionManager.IErrorHandler errorHandler;

    public ExplanationSourceDelegate(IExplanationSource source, ExtensionManager.IErrorHandler errorHandler) {
        this.source = source;
        this.errorHandler = errorHandler;
    }

    public IExplanationInput getExplanationInput(final ISelection selection) {
        IExplanationInput input = (IExplanationInput)SafeRunner.run((ISafeRunnableWithResult)new ISafeRunnableWithResult<IExplanationInput>(){

            public IExplanationInput runWithResult() throws Exception {
                return ExplanationSourceDelegate.this.source.getExplanationInput(selection);
            }

            public void handleException(Throwable exception) {
                ExplanationSourceDelegate.this.errorHandler.handleError(exception);
            }
        });
        if (input != null) {
            return new ExplanationInputDelegate(input, this.errorHandler);
        }
        return null;
    }

    public boolean insertExplanationAsComment(final ITextEditor editor, final IExplanationLanguage language, final String explanation, final int startLine) {
        return (Boolean)SafeRunner.run((ISafeRunnableWithResult)new ISafeRunnableWithResult<Boolean>(){

            public Boolean runWithResult() throws Exception {
                return ExplanationSourceDelegate.this.source.insertExplanationAsComment(editor, language, explanation, startLine);
            }

            public void handleException(Throwable exception) {
                ExplanationSourceDelegate.this.errorHandler.handleError(exception);
            }
        });
    }

    public boolean insertExplanationAsComment(final ITextEditor editor, final IExplanationLanguage language, final String explanation) {
        return (Boolean)SafeRunner.run((ISafeRunnableWithResult)new ISafeRunnableWithResult<Boolean>(){

            public Boolean runWithResult() throws Exception {
                return ExplanationSourceDelegate.this.source.insertExplanationAsComment(editor, language, explanation);
            }

            public void handleException(Throwable exception) {
                ExplanationSourceDelegate.this.errorHandler.handleError(exception);
            }
        });
    }

    public void dispose() {
        SafeRunner.run(() -> this.source.dispose());
    }
}

