/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.extensionpoint;

import com.ibm.systemz.wcaz4e.extensions.IExplanationService;
import com.ibm.systemz.wcaz4e.languages.LanguageTester;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class ExplanationService
implements IExplanationService {
    IContextActivation activation = null;
    IWorkbenchPart part = null;
    boolean enabled = false;

    public ExplanationService(IWorkbenchPart part) {
        this.part = part;
    }

    public void setExplanationLanguage(IExplanationService.LANGUAGE expLanguage) {
        if (this.part == null || this.part.getSite() == null) {
            return;
        }
        if (expLanguage == null) {
            this.clearActivation();
        } else {
            LanguageTester.LANGUAGE language = null;
            switch (expLanguage) {
                case COBOL: {
                    language = LanguageTester.LANGUAGE.COBOL;
                    break;
                }
                case JCL: {
                    language = LanguageTester.LANGUAGE.JCL;
                    break;
                }
                case PL1: {
                    language = LanguageTester.LANGUAGE.PL1;
                    break;
                }
                case REXX: {
                    language = LanguageTester.LANGUAGE.REXX;
                    break;
                }
                case HLASM: {
                    language = LanguageTester.LANGUAGE.HLASM;
                    break;
                }
            }
            if (language != null) {
                if (this.activation != null && language.getWcaz4eContextId().equals(this.activation.getContextId())) {
                    return;
                }
                this.clearActivation();
                IContextService service = (IContextService)this.part.getSite().getService(IContextService.class);
                if (service != null) {
                    this.activation = service.activateContext(language.getWcaz4eContextId());
                }
            } else {
                this.clearActivation();
            }
        }
    }

    public IExplanationService.LANGUAGE getExplanationLanguage() {
        if (this.activation != null) {
            LanguageTester.LANGUAGE[] lANGUAGEArray = LanguageTester.LANGUAGE.values();
            int n = lANGUAGEArray.length;
            int n2 = 0;
            while (n2 < n) {
                LanguageTester.LANGUAGE language = lANGUAGEArray[n2];
                if (language.getWcaz4eContextId().equals(this.activation.getContextId())) {
                    switch (language) {
                        case COBOL: {
                            return IExplanationService.LANGUAGE.COBOL;
                        }
                        case JCL: {
                            return IExplanationService.LANGUAGE.JCL;
                        }
                        case PL1: {
                            return IExplanationService.LANGUAGE.PL1;
                        }
                        case REXX: {
                            return IExplanationService.LANGUAGE.REXX;
                        }
                        case HLASM: {
                            return IExplanationService.LANGUAGE.HLASM;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    void dispose() {
        this.part = null;
        this.clearActivation();
    }

    private void clearActivation() {
        if (this.activation != null) {
            if (this.part != null && this.part.getSite() != null) {
                IContextService service = (IContextService)this.part.getSite().getService(IContextService.class);
                service.deactivateContext(this.activation);
            }
            this.activation.clearResult();
            this.activation.clearActive();
            this.activation = null;
        }
    }
}

