/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.explanation;

import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.wca4z.code.explanation.ExplanationAssistant;
import com.ibm.cloud.wca4z.code.explanation.model.InfoResponse;
import com.ibm.systemz.wcaz4e.Tracer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LocaleSupportService {
    private static volatile LocaleSupportService instance;
    private final Set<String> supportedLocales;

    private LocaleSupportService(ExplanationAssistant assistant) {
        this.supportedLocales = this.fetchSupportedLocales(assistant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocaleSupportService getInstance(ExplanationAssistant assistant) {
        if (instance != null) return instance;
        Class<LocaleSupportService> clazz = LocaleSupportService.class;
        synchronized (LocaleSupportService.class) {
            if (instance != null) return instance;
            instance = new LocaleSupportService(assistant);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private Set<String> fetchSupportedLocales(ExplanationAssistant assistant) {
        try {
            Response response = assistant.getInfo().execute();
            if (((InfoResponse)response.getResult()).getMetadata().containsKey("supported_locales")) {
                HashSet<String> supportedLocales = new HashSet<String>((List)((InfoResponse)response.getResult()).getMetadata().get("supported_locales"));
                return supportedLocales;
            }
            return new HashSet<String>();
        }
        catch (Exception e) {
            Tracer.trace().trace("/debug/api", e.getMessage(), e.getCause());
            return Collections.emptySet();
        }
    }

    public boolean isLocaleSupported(String locale) {
        return this.supportedLocales.contains(locale);
    }

    public Set<String> getSupportedLocales() {
        return Collections.unmodifiableSet(this.supportedLocales);
    }
}

