/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.explanation;

import com.ibm.systemz.wcaz4e.Activator;
import com.ibm.systemz.wcaz4e.Messages;
import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.actions.Command;
import com.ibm.systemz.wcaz4e.explanation.AiExplainedDialog;
import com.ibm.systemz.wcaz4e.explanation.CodeExplanationInput;
import com.ibm.systemz.wcaz4e.explanation.CodeExplanationJob;
import com.ibm.systemz.wcaz4e.extensions.IExplanationLanguage;
import com.ibm.systemz.wcaz4e.languages.CobolLanguage;
import com.ibm.systemz.wcaz4e.languages.HlasmLanguage;
import com.ibm.systemz.wcaz4e.languages.JclLanguage;
import com.ibm.systemz.wcaz4e.languages.PliLanguage;
import com.ibm.systemz.wcaz4e.languages.RexxLanguage;
import com.ibm.systemz.wcaz4e.preferences.PreferenceUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodeExplanationView
extends ViewPart {
    public static final String ID = "com.ibm.systemz.wcaz4e.explanation.CodeExplanationView";
    public static final String FONT_ID = "com.ibm.systemz.wcaz4e.theme.category.font";
    CodeExplanationJob explanationJob = null;
    Text explanationTypeHeader;
    StyledText sourceLink;
    StyledText commentsLink;
    Text messageText;
    Font font;
    boolean disposed = false;

    public void createPartControl(Composite parent) {
        Composite middle = new Composite(parent, 0);
        middle.setLayout((Layout)new GridLayout(1, true));
        middle.setLayoutData((Object)new GridData(1808));
        this.explanationTypeHeader = new Text(middle, 74);
        this.explanationTypeHeader.setLayoutData((Object)new GridData(768));
        Composite subheader = new Composite(middle, 0);
        subheader.setLayout((Layout)new GridLayout(2, false));
        middle.setLayoutData((Object)new GridData(768));
        this.sourceLink = new StyledText(subheader, 74);
        this.sourceLink.addListener(3, event -> {
            int offset = this.sourceLink.getOffsetAtPoint(new Point(event.x, event.y));
            if (offset != -1) {
                StyleRange style = null;
                try {
                    style = this.sourceLink.getStyleRangeAtOffset(offset);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (style != null && style.underline && style.underlineStyle == 4 && this.explanationJob != null && this.explanationJob.getExplanationInput() != null) {
                    this.explanationJob.getExplanationInput().jumpToSourceLocation();
                }
            }
        });
        this.sourceLink.setLayoutData((Object)new GridData(512));
        this.commentsLink = new StyledText(subheader, 74);
        this.commentsLink.addListener(3, event -> {
            PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"com.ibm.systemz.wcaz4e.preferences.general", null, null);
            if (prefDialog != null) {
                prefDialog.open();
            }
        });
        this.commentsLink.setLayoutData((Object)new GridData(512));
        this.messageText = new Text(middle, 2890);
        this.messageText.setLayoutData((Object)new GridData(1808));
        if (JFaceResources.getFontRegistry().hasValueFor(FONT_ID)) {
            this.messageText.setFont(JFaceResources.getFont((String)FONT_ID));
        } else {
            this.messageText.setFont(JFaceResources.getTextFont());
        }
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(event -> {
            if (event.getProperty().equalsIgnoreCase(FONT_ID)) {
                if (this.font != null && !this.font.isDisposed()) {
                    this.font.dispose();
                }
                this.updateFont();
                this.messageText.redraw();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ID);
    }

    public void setFocus() {
        this.messageText.setFocus();
    }

    public synchronized void setInput(CodeExplanationInput input) {
        if (this.explanationJob != null) {
            this.explanationJob.cancel();
        }
        this.explanationJob = new CodeExplanationJob(this, input);
        this.explanationJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                if (CodeExplanationView.this.explanationJob == CodeExplanationView.this.explanationJob) {
                    CodeExplanationView.this.updateDisplay();
                }
            }
        });
        this.explanationJob.schedule();
    }

    public void updateFont() {
        FontRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        FontData[] fontdata = registry.getFontData(FONT_ID);
        if (fontdata != null && fontdata.length > 0) {
            if (this.font != null && !this.font.isDisposed()) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.messageText.getDisplay(), fontdata);
            this.messageText.setFont(this.font);
        }
    }

    public void updateDisplay() {
        Activator.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CodeExplanationJob fJob = CodeExplanationView.this.explanationJob;
                if (fJob != null) {
                    boolean generating = fJob.getResult() == null;
                    String lines = fJob.getExplanationInput().getSourceStartLine() == fJob.getExplanationInput().getSourceEndLine() ? "" + (fJob.getExplanationInput().getSourceStartLine() + 1) : fJob.getExplanationInput().getSourceStartLine() + 1 + " - " + (fJob.getExplanationInput().getSourceEndLine() + 1);
                    String fileName = fJob.getExplanationInput().getFileName();
                    String explanationType = switch (fJob.getExplanationInput().getCommand()) {
                        case Command.SIMPLE -> Messages.CodeExplanationView_explanationType_simple;
                        case Command.DETAILED -> Messages.CodeExplanationView_explanationType_detailed;
                        case Command.GUIDED -> Messages.CodeExplanationView_explanationType_guided;
                        default -> Messages.CodeExplanationView_explanationType_unknown;
                    };
                    String fExplanationType = generating ? MessageFormat.format(Messages.CodeExplanationView_generatingExplanationType, explanationType) : explanationType;
                    String commentIndicator = PreferenceUtil.getOptInComments() ? Messages.CodeExplanationView_yes : Messages.CodeExplanationView_no;
                    StyleRange style = new StyleRange();
                    style.underline = true;
                    style.underlineStyle = 4;
                    String localized = MessageFormat.format(Messages.CodeExplanationView_source_link, fJob.getExplanationInput().getFileName(), lines);
                    CodeExplanationView.this.explanationTypeHeader.setText(fExplanationType);
                    CodeExplanationView.this.sourceLink.setText(localized);
                    CodeExplanationView.this.commentsLink.setText(" " + MessageFormat.format(Messages.CodeExplanationView_includes_comments, commentIndicator));
                    int[] ranges = new int[]{localized.indexOf(fileName), fileName.length(), localized.indexOf(lines), lines.length()};
                    StyleRange[] styles = new StyleRange[]{style, style};
                    CodeExplanationView.this.sourceLink.setStyleRanges(ranges, styles);
                    CodeExplanationView.this.sourceLink.requestLayout();
                    StyleRange commentStyle = new StyleRange();
                    commentStyle.underline = true;
                    commentStyle.underlineStyle = 4;
                    StyleRange[] commentStyles = new StyleRange[]{commentStyle};
                    int[] commentRanges = new int[]{CodeExplanationView.this.commentsLink.getText().indexOf(commentIndicator), commentIndicator.length()};
                    CodeExplanationView.this.commentsLink.setStyleRanges(commentRanges, commentStyles);
                    CodeExplanationView.this.commentsLink.requestLayout();
                    CodeExplanationView.this.messageText.setText(fJob.getExplanationText());
                    CodeExplanationView.this.updateFont();
                    CodeExplanationView.this.updateEnablements();
                }
            }
        });
    }

    public void runCommand(Command command) {
        switch (command) {
            case COPY: {
                this.doCopy();
                break;
            }
            case DOWNLOAD: {
                this.doDownload();
                break;
            }
            case INSERT: {
                this.doInsert();
                break;
            }
            case REGENERATE: 
            case REGENERATE_SIMPLE: 
            case REGENERATE_DETAILED: 
            case REGENERATE_GUIDED: {
                this.doRegenerate(command);
                break;
            }
            case AIEXPLAINED: {
                this.doAiExplained();
                break;
            }
        }
    }

    private void doCopy() {
        TextTransfer textTransfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(Activator.getDisplay());
        String selectionText = this.messageText.getSelectionText();
        if (selectionText != null && !selectionText.isEmpty()) {
            clipboard.setContents(new Object[]{selectionText}, new Transfer[]{textTransfer});
        } else if (this.messageText.getText() != null && !this.messageText.getText().isEmpty()) {
            clipboard.setContents(new Object[]{this.messageText.getText()}, new Transfer[]{textTransfer});
        }
    }

    private void doInsert() {
        final CodeExplanationJob fJob = this.explanationJob;
        if (fJob != null && fJob.getResult() != null && fJob.containsExplanation()) {
            Activator.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    fJob.getExplanationInput().jumpToSourceLocation();
                    IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                    if (editor != null && editor instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editor;
                        if (textEditor.isEditable()) {
                            int insertionLine = fJob.getExplanationInput().getSourceStartLine();
                            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                            insertionLine = Math.max(0, insertionLine);
                            insertionLine = Math.min(document.getNumberOfLines() - 1, insertionLine);
                            String explanation = fJob.getExplanationInput().getAttribution(fJob.getExplanationLocale(), false) + CodeExplanationView.this.messageText.getText();
                            fJob.getExplanationInput().insertExplanationAsComment((ITextEditor)editor, explanation, insertionLine);
                        } else {
                            Tracer.trace().trace("/debug/explanation", "Active text editor is not editable");
                        }
                    } else {
                        Tracer.trace().trace("/debug/explanation", "Active editor is not a text editor");
                    }
                }
            });
        }
    }

    private void doDownload() {
        CodeExplanationJob fJob = this.explanationJob;
        if (fJob != null && fJob.getResult() != null && fJob.containsExplanation()) {
            FileDialog fileDialog = new FileDialog(this.getViewSite().getShell(), 8192);
            fileDialog.setFileName("codeExplanation.txt");
            fileDialog.setFilterExtensions(new String[]{"*.txt"});
            fileDialog.setOverwrite(true);
            fileDialog.setText(Messages.CodeExplanationView_download_title);
            String absolutePath = fileDialog.open();
            if (absolutePath != null) {
                try {
                    FileWriter writer = new FileWriter(new File(absolutePath));
                    writer.write(fJob.getExplanationInput().getAttribution(fJob.getExplanationLocale(), true));
                    writer.write(fJob.getExplanationText());
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void doRegenerate(Command command) {
        if (this.explanationJob != null) {
            switch (command) {
                case REGENERATE: {
                    break;
                }
                case REGENERATE_SIMPLE: {
                    this.explanationJob.getExplanationInput().setCommand(Command.SIMPLE);
                    break;
                }
                case REGENERATE_DETAILED: {
                    this.explanationJob.getExplanationInput().setCommand(Command.DETAILED);
                    break;
                }
                case REGENERATE_GUIDED: {
                    this.explanationJob.getExplanationInput().setCommand(Command.GUIDED);
                    break;
                }
            }
            this.setInput(this.explanationJob.getExplanationInput());
        }
    }

    private void doAiExplained() {
        String modelId = this.explanationJob != null ? this.explanationJob.getExplanationModelId() : null;
        AiExplainedDialog dialog = new AiExplainedDialog(Activator.getDisplay().getActiveShell(), modelId);
        dialog.open();
    }

    public boolean isRegenerateCommandEnabled(Command command) {
        IExplanationLanguage language;
        if (this.explanationJob != null && (language = this.explanationJob.getExplanationInput().getExplanationLanguage()) != null) {
            if (language instanceof CobolLanguage || language instanceof PliLanguage) {
                return command == Command.SIMPLE || command == Command.DETAILED || command == Command.GUIDED;
            }
            if (language instanceof JclLanguage || language instanceof RexxLanguage || language instanceof HlasmLanguage) {
                return command == Command.SIMPLE || command == Command.DETAILED;
            }
        }
        return false;
    }

    public Command getActiveCommand() {
        if (this.explanationJob != null) {
            return this.explanationJob.getExplanationInput().command;
        }
        return null;
    }

    private void updateEnablements() {
    }

    public void dispose() {
        super.dispose();
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        this.disposed = true;
    }
}

