/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.explanation;

import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.service.exception.BadRequestException;
import com.ibm.cloud.wca4z.code.explanation.ExplanationAssistant;
import com.ibm.cloud.wca4z.code.explanation.common.GsonTypeConverter;
import com.ibm.cloud.wca4z.code.explanation.model.CreateExplanationOptions;
import com.ibm.cloud.wca4z.code.explanation.model.ExplanationResponse;
import com.ibm.cloud.wca4z.code.explanation.model.MessageRecord;
import com.ibm.cloud.wca4z.code.explanation.model.NaturalLanguage;
import com.ibm.cloud.wca4z.code.explanation.model.RequestTranslationOptions;
import com.ibm.cloud.wca4z.code.explanation.model.TranslateResponse;
import com.ibm.systemz.wcaz4e.Activator;
import com.ibm.systemz.wcaz4e.Messages;
import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.api.ApiManager;
import com.ibm.systemz.wcaz4e.api.ApiResponse;
import com.ibm.systemz.wcaz4e.explanation.CodeExplanationInput;
import com.ibm.systemz.wcaz4e.explanation.CodeExplanationView;
import com.ibm.systemz.wcaz4e.explanation.LocaleSupportService;
import com.ibm.systemz.wcaz4e.extensions.IExplanationLanguage;
import com.ibm.systemz.wcaz4e.languages.CobolLanguage;
import com.ibm.systemz.wcaz4e.languages.HlasmLanguage;
import com.ibm.systemz.wcaz4e.languages.JclLanguage;
import com.ibm.systemz.wcaz4e.languages.PliLanguage;
import com.ibm.systemz.wcaz4e.languages.RexxLanguage;
import com.ibm.systemz.wcaz4e.preferences.PreferenceUtil;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class CodeExplanationJob
extends Job {
    private boolean loremIpsum = Boolean.getBoolean("com.ibm.systemz.wcaz4e.explanation.loremipsum");
    CodeExplanationView view;
    CodeExplanationInput input;
    boolean cancelled;
    String explanationText = Messages.CodeExplanationView_generatingInProgress;
    String explanationModelId = null;
    String explanationLocale = null;
    boolean containsExplanation = false;

    public CodeExplanationJob(CodeExplanationView view, CodeExplanationInput input) {
        super(CodeExplanationJob.getJobName(input));
        this.view = view;
        this.input = input;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(CodeExplanationJob.getExplanationType(this.input), -1);
        monitor.subTask(Messages.CodeExplanationJob_subtask_authenticate);
        IStatus result = Status.OK_STATUS;
        this.view.updateDisplay();
        if (this.loremIpsum) {
            this.explanationText = "lorem\nipsum";
            this.explanationModelId = "lorem-ipsum";
            this.explanationLocale = "en";
            return Status.OK_STATUS;
        }
        try {
            monitor.subTask(Messages.CodeExplanationJob_subtask_explain);
            String level = null;
            switch (this.input.getCommand()) {
                case SIMPLE: {
                    level = "simple";
                    break;
                }
                case DETAILED: {
                    level = "detailed";
                    break;
                }
                case GUIDED: {
                    level = "guided";
                    break;
                }
            }
            String apiLanguage = null;
            IExplanationLanguage explanationLanguage = this.input.getExplanationLanguage();
            if (explanationLanguage instanceof CobolLanguage) {
                apiLanguage = "cobol";
            } else if (explanationLanguage instanceof JclLanguage) {
                apiLanguage = "jcl";
            } else if (explanationLanguage instanceof PliLanguage) {
                apiLanguage = "pl1";
            } else if (explanationLanguage instanceof RexxLanguage) {
                apiLanguage = "rexx";
            } else if (explanationLanguage instanceof HlasmLanguage) {
                apiLanguage = "hlasm";
            } else {
                Status errorStatus = new Status(4, "com.ibm.systemz.wcaz4e", Messages.CodeExplanationJob_error_unknown_language);
                throw new CoreException((IStatus)errorStatus);
            }
            ExplanationAssistant assistant = ApiManager.getServiceInstance(Activator.getInstance().getUserAgent(), ExplanationAssistant.class);
            Response response = assistant.createExplanation(new CreateExplanationOptions.Builder().sourceCode(this.input.getSourceToExplain().getBytes()).lang(apiLanguage.toUpperCase()).level(level).moderations(Map.of("include_comment", PreferenceUtil.getOptInComments())).build()).execute();
            ExplanationResponse explanationResponse = (ExplanationResponse)response.getResult();
            this.explanationText = explanationResponse.getGeneratedText();
            this.explanationModelId = explanationResponse.getMetadata().get("model_id").toString();
            this.explanationLocale = explanationResponse.getMetadata().get("locale").toString();
            result = ((MessageRecord)GsonTypeConverter.convert(explanationResponse.getMetadata().get("message_record"), MessageRecord.class)).getStatus();
            this.containsExplanation = true;
            if (this.shouldTranslate(this.explanationLocale, assistant)) {
                this.explanationText = this.translateExplanation(assistant, this.explanationText, this.explanationLocale);
            }
        }
        catch (CoreException e) {
            this.explanationText = Messages.CodeExplanationJob_noExplanationGenerated;
            if (!monitor.isCanceled()) {
                result = e.getStatus();
            } else {
                Tracer.trace().trace("/debug/api", "monitor canceled", (Throwable)e);
            }
        }
        catch (BadRequestException e) {
            this.explanationText = Messages.CodeExplanationJob_noExplanationGenerated;
            ApiResponse.ErrorResponse errResp = (ApiResponse.ErrorResponse)GsonTypeConverter.convert((Object)e.getResponseBody(), ApiResponse.ErrorResponse.class);
            result = new Status(4, ExplanationAssistant.class, errResp.getError_description());
            Tracer.trace().trace("/debug/api", String.join((CharSequence)"\n", List.of(errResp.getErrors()).stream().map(err -> err.getMessage()).toList()), (Throwable)e);
        }
        catch (Exception e) {
            this.explanationText = Messages.CodeExplanationJob_noExplanationGenerated;
            result = new Status(4, ExplanationAssistant.class, e.getMessage());
            Tracer.trace().trace("/debug/api", e.getMessage(), e.getCause());
        }
        if (result.getSeverity() == 2) {
            StatusAdapter adapter = new StatusAdapter(result);
            adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)MessageFormat.format(Messages.CodeExplanationJob_jobReturnedWithWarning, this.getName()));
            StatusManager.getManager().handle(adapter, 2);
        }
        return result;
    }

    public CodeExplanationInput getExplanationInput() {
        return this.input;
    }

    public boolean containsExplanation() {
        return this.containsExplanation;
    }

    public String getExplanationText() {
        return this.explanationText;
    }

    public String getExplanationModelId() {
        return this.explanationModelId;
    }

    public String getExplanationLocale() {
        return this.explanationLocale;
    }

    private static String getExplanationType(CodeExplanationInput input) {
        String explanationType = Messages.CodeExplanationView_explanationType_unknown;
        if (input != null) {
            switch (input.getCommand()) {
                case SIMPLE: {
                    explanationType = Messages.CodeExplanationView_explanationType_simple;
                    break;
                }
                case DETAILED: {
                    explanationType = Messages.CodeExplanationView_explanationType_detailed;
                    break;
                }
                case GUIDED: {
                    explanationType = Messages.CodeExplanationView_explanationType_guided;
                    break;
                }
            }
        }
        return explanationType;
    }

    private static String getJobName(CodeExplanationInput input) {
        String explanationType = CodeExplanationJob.getExplanationType(input);
        String fileName = input.getFileName();
        if (fileName != null) {
            return MessageFormat.format(Messages.CodeExplanationJob_job_name_type_file, explanationType, fileName);
        }
        return explanationType;
    }

    private boolean shouldTranslate(String explanationLocale, ExplanationAssistant assistant) {
        return PreferenceUtil.getNativeLangExplanation() && !explanationLocale.contains("en") && LocaleSupportService.getInstance(assistant).isLocaleSupported(explanationLocale);
    }

    private String translateExplanation(ExplanationAssistant assistant, String text, String targetLocale) {
        RequestTranslationOptions options = new RequestTranslationOptions.Builder().contentLanguage("en-US").acceptLanguage(targetLocale).naturalLanguage(new NaturalLanguage.Builder().text(text.getBytes(StandardCharsets.UTF_8)).build()).type("natural_language").build();
        try {
            Response response = assistant.requestTranslation(options).execute();
            return ((TranslateResponse)response.getResult()).getGeneratedText();
        }
        catch (Exception e) {
            Tracer.trace().trace("/debug/api", e.getMessage(), e.getCause());
            return text;
        }
    }
}

