/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.explanation;

import com.ibm.systemz.wcaz4e.Activator;
import com.ibm.systemz.wcaz4e.Messages;
import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.actions.Command;
import com.ibm.systemz.wcaz4e.api.explanations.Explanations;
import com.ibm.systemz.wcaz4e.extensionpoint.ExplanationSourceDelegate;
import com.ibm.systemz.wcaz4e.extensionpoint.ExplorerExplanationInput;
import com.ibm.systemz.wcaz4e.extensionpoint.ExtensionManager;
import com.ibm.systemz.wcaz4e.extensionpoint.TextEditorExplanationInput;
import com.ibm.systemz.wcaz4e.extensions.IExplanationInput;
import com.ibm.systemz.wcaz4e.extensions.IExplanationLanguage;
import com.ibm.systemz.wcaz4e.extensions.IExplanationService;
import com.ibm.systemz.wcaz4e.extensions.IExplanationSource;
import com.ibm.systemz.wcaz4e.languages.CobolLanguage;
import com.ibm.systemz.wcaz4e.languages.HlasmLanguage;
import com.ibm.systemz.wcaz4e.languages.JclLanguage;
import com.ibm.systemz.wcaz4e.languages.LanguageTester;
import com.ibm.systemz.wcaz4e.languages.PliLanguage;
import com.ibm.systemz.wcaz4e.languages.RexxLanguage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class CodeExplanationInput {
    protected Command command;
    protected IContentType contentType;
    protected IExplanationSource explanationSource;
    protected IExplanationLanguage explanationLanguage;
    protected IExplanationInput input;

    public static CodeExplanationInput createInput(IWorkbenchPart part, ISelection selection, Command command) {
        CodeExplanationInput result = new CodeExplanationInput(part, selection, command);
        if (!result.hasInput() && !"com.ibm.systemz.jcl.editor.jface.editor.JclEditorID".equals(part.getSite().getId())) {
            result = new CodeExplanationInput((ITextEditor)part, (ITextSelection)selection, command);
        }
        return result;
    }

    private CodeExplanationInput(IWorkbenchPart part, ISelection selection, Command command) {
        block12: {
            block13: {
                this.command = command;
                if (!(part instanceof CommonNavigator) && (part == null || !part.toString().contains("com.ibm.etools.common.navigator.CommonNavigator"))) break block13;
                if (!(selection instanceof TreeSelection)) break block12;
                LanguageTester.LANGUAGE language = null;
                if (selection instanceof TreeSelection && ((TreeSelection)selection).size() == 1) {
                    IAdaptable adaptable = (IAdaptable)((TreeSelection)selection).getFirstElement();
                    IFile file = (IFile)adaptable.getAdapter(IFile.class);
                    language = LanguageTester.getFileExtensionLanguage(file.getFileExtension());
                }
                if (language == null) {
                    return;
                }
                this.explanationLanguage = CodeExplanationInput.getExplanationLanguage(language);
                if (this.input != null) break block12;
                this.input = new ExplorerExplanationInput(part, (ITreeSelection)selection);
                break block12;
            }
            if (part != null && part.toString().contains("com.ez.mainframe.editors")) {
                ExtensionManager.ExplanationSource[] sources;
                ExtensionManager em = Activator.getInstance().getExtensionManager();
                ExtensionManager.ExplanationSource[] explanationSourceArray = sources = em.getExplanationSourcesForWorkbenchPart(part);
                int n = sources.length;
                int n2 = 0;
                while (n2 < n) {
                    ExtensionManager.ExplanationSource source = explanationSourceArray[n2];
                    if (source.getService().getExplanationLanguage() != null) {
                        this.input = source.getSource().getExplanationInput(selection);
                        if (this.input != null && source.getService().getExplanationLanguage() != null) {
                            this.explanationSource = source.getSource();
                            this.explanationLanguage = CodeExplanationInput.getExplanationLanguage(source.getService());
                            break;
                        }
                    }
                    ++n2;
                }
            } else {
                ExtensionManager em = Activator.getInstance().getExtensionManager();
                ExtensionManager.ExplanationSource[] sources = em.getExplanationSourcesForWorkbenchPart(part);
                if (part instanceof ContentOutline) {
                    this.getExplanationInputForContentOutline(selection, sources);
                } else {
                    ExtensionManager.ExplanationSource[] explanationSourceArray = sources;
                    int n = sources.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ExtensionManager.ExplanationSource source = explanationSourceArray[n3];
                        if (source.getService().getExplanationLanguage() != null) {
                            this.input = source.getSource().getExplanationInput(selection);
                            if (this.input != null && source.getService().getExplanationLanguage() != null) {
                                this.explanationSource = source.getSource();
                                this.explanationLanguage = CodeExplanationInput.getExplanationLanguage(source.getService());
                                break;
                            }
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    private String getLanguageFromOutlineElementType(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object element = ss.getFirstElement();
            String className = element.getClass().getSimpleName().toLowerCase();
            if (element != null) {
                if (className.contains("cob")) {
                    return Explanations.LANGUAGE.COBOL.name();
                }
                if (className.contains("pli")) {
                    return "pli";
                }
                if (className.contains("jcl")) {
                    return Explanations.LANGUAGE.JCL.name();
                }
                if (className.contains("DocumentSymbol")) {
                    return Explanations.LANGUAGE.REXX.name();
                }
            }
        }
        return null;
    }

    private void getExplanationInputForContentOutline(ISelection selection, ExtensionManager.ExplanationSource[] sources) {
        String language = this.getLanguageFromOutlineElementType(selection) != null ? this.getLanguageFromOutlineElementType(selection).toLowerCase() : this.getLanguageFromOutlineElementType(selection);
        ExtensionManager.ExplanationSource[] explanationSourceArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            ExtensionManager.ExplanationSource source = explanationSourceArray[n2];
            IExplanationSource current = source.getSource();
            if (current instanceof ExplanationSourceDelegate) {
                try {
                    String className;
                    Field sourceField = current.getClass().getDeclaredField("source");
                    sourceField.setAccessible(true);
                    Object target = sourceField.get(current);
                    if (target != null && (className = target.getClass().getSimpleName().toLowerCase()).contains(language)) {
                        this.explanationSource = (IExplanationSource)target;
                        this.explanationLanguage = CodeExplanationInput.getExplanationLanguage(source.getService());
                        Method method = target.getClass().getDeclaredMethod("getExplanationInput", ISelection.class);
                        method.setAccessible(true);
                        this.input = (IExplanationInput)method.invoke(target, selection);
                        break;
                    }
                }
                catch (Exception e) {
                    Tracer.trace().trace("/debug/api", "Error occured", (Throwable)e);
                }
            }
            ++n2;
        }
    }

    private CodeExplanationInput(ITextEditor editor, ITextSelection selection, Command command) {
        this.command = command;
        this.explanationLanguage = CodeExplanationInput.getExplanationLanguage(editor.getEditorInput());
        if (this.input == null) {
            this.input = new TextEditorExplanationInput(editor, selection);
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean hasInput() {
        return this.input != null;
    }

    public String getSourceToExplain() {
        return this.input.getSourceText();
    }

    public int getSourceStartLine() {
        return this.input.getSourceStartLine();
    }

    public int getSourceEndLine() {
        return this.input.getSourceEndLine();
    }

    public String getReferenceWord() {
        return this.input.getReferenceWord();
    }

    public String getReferenceWordType() {
        return this.input.getReferenceWordType();
    }

    public String getFileName() {
        return this.input.getSourceFileName();
    }

    public Command getCommand() {
        return this.command;
    }

    public IExplanationLanguage getExplanationLanguage() {
        return this.explanationLanguage;
    }

    public static IExplanationLanguage getExplanationLanguage(ITextEditor editor) {
        return CodeExplanationInput.getExplanationLanguage(editor.getEditorInput());
    }

    public static IExplanationLanguage getExplanationLanguage(IExplanationService service) {
        if (IExplanationService.LANGUAGE.COBOL.equals((Object)service.getExplanationLanguage())) {
            return new CobolLanguage();
        }
        if (IExplanationService.LANGUAGE.JCL.equals((Object)service.getExplanationLanguage())) {
            return new JclLanguage();
        }
        if (IExplanationService.LANGUAGE.PL1.equals((Object)service.getExplanationLanguage())) {
            return new PliLanguage();
        }
        if (IExplanationService.LANGUAGE.REXX.equals((Object)service.getExplanationLanguage())) {
            return new RexxLanguage();
        }
        if (IExplanationService.LANGUAGE.HLASM.equals((Object)service.getExplanationLanguage())) {
            return new HlasmLanguage();
        }
        return null;
    }

    public static IExplanationLanguage getExplanationLanguage(IEditorInput editorInput) {
        if (LanguageTester.doesEditorInputSupportLanguage(editorInput, LanguageTester.LANGUAGE.COBOL)) {
            return new CobolLanguage();
        }
        if (LanguageTester.doesEditorInputSupportLanguage(editorInput, LanguageTester.LANGUAGE.JCL)) {
            return new JclLanguage();
        }
        if (LanguageTester.doesEditorInputSupportLanguage(editorInput, LanguageTester.LANGUAGE.PL1)) {
            return new PliLanguage();
        }
        if (LanguageTester.doesEditorInputSupportLanguage(editorInput, LanguageTester.LANGUAGE.REXX)) {
            return new RexxLanguage();
        }
        if (LanguageTester.doesEditorInputSupportLanguage(editorInput, LanguageTester.LANGUAGE.HLASM)) {
            return new HlasmLanguage();
        }
        return null;
    }

    public static IExplanationLanguage getExplanationLanguage(LanguageTester.LANGUAGE language) {
        if (language == LanguageTester.LANGUAGE.COBOL) {
            return new CobolLanguage();
        }
        if (language == LanguageTester.LANGUAGE.JCL) {
            return new JclLanguage();
        }
        if (language == LanguageTester.LANGUAGE.PL1) {
            return new PliLanguage();
        }
        if (language == LanguageTester.LANGUAGE.REXX) {
            return new RexxLanguage();
        }
        if (language == LanguageTester.LANGUAGE.HLASM) {
            return new HlasmLanguage();
        }
        return null;
    }

    public void insertExplanationAsComment(ITextEditor editor, String explanation, int insertLine) {
        int insertionOffset;
        block10: {
            if (this.explanationSource != null && this.explanationSource.insertExplanationAsComment(editor, this.explanationLanguage, explanation, insertLine)) {
                return;
            }
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            String insertionText = this.explanationLanguage.getInsertionText(document, explanation, insertLine);
            insertionOffset = this.explanationLanguage.getInsertionOffset(document, insertLine);
            IRewriteTarget rewriteTarget = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
            if (rewriteTarget != null) {
                rewriteTarget.beginCompoundChange();
            }
            try {
                try {
                    document.replace(insertionOffset, 0, insertionText);
                }
                catch (BadLocationException ble) {
                    Tracer.trace().trace("/debug/explanation", ble.getLocalizedMessage(), (Throwable)ble);
                    ble.printStackTrace();
                    if (rewriteTarget != null) {
                        rewriteTarget.endCompoundChange();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (rewriteTarget != null) {
                    rewriteTarget.endCompoundChange();
                }
                throw throwable;
            }
            if (rewriteTarget != null) {
                rewriteTarget.endCompoundChange();
            }
        }
        editor.selectAndReveal(insertionOffset, 0);
    }

    public void jumpToSourceLocation() {
        this.input.jumpToSourceLocation();
    }

    public String getAttribution(String explanationLocale, boolean downloadFormat) {
        String dateTime;
        Locale ideLocale = Locale.getDefault();
        if (ideLocale.getLanguage() != null && ideLocale.getLanguage().startsWith("en")) {
            Locale enAELocale = new Locale("en", "AE");
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3, enAELocale);
            dateTime = dateFormat.format(new Date()).replace(",", "");
        } else {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3, ideLocale);
            dateTime = dateFormat.format(new Date());
        }
        return downloadFormat ? MessageFormat.format(Messages.CodeExplanationInput_attribution_for_download, dateTime) + System.getProperty("line.separator") + System.getProperty("line.separator") : Messages.CodeExplanationInput_attribution_wcaz + System.getProperty("line.separator") + dateTime + System.getProperty("line.separator");
    }
}

