/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.explanation;

import com.ibm.systemz.wcaz4e.Activator;
import com.ibm.systemz.wcaz4e.Messages;
import java.awt.Desktop;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AiExplainedDialog
extends TitleAreaDialog {
    private String modelId = null;
    private static final Map<String, String> modelLinks = new HashMap<String, String>();

    static {
        modelLinks.put("ibm/granite-code-z-xplain", "https://www.ibm.com/docs/en/watsonx/watsonx-code-assistant-4z/2.x?topic=z-granite-code-xplain-model-card");
        modelLinks.put("ibm/granite-20b-code-cobol-v1", "https://www.ibm.com/docs/en/watsonx/watsonx-code-assistant-4z/2.x?topic=z-granite20bcodecobol-model-card");
        modelLinks.put("ibm/granite-3-8b-instruct", "https://www.ibm.com/docs/en/watsonx/w-and-w/2.1.0?topic=models-granite-30-8b-instruct-model-card");
    }

    public AiExplainedDialog(Shell parentShell, String modelId) {
        super(parentShell);
        this.modelId = modelId;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.AiExplainedDialog_name);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AiExplainedDialog_title);
        this.setMessage(Messages.AiExplainedDialog_description);
        Composite middle = new Composite(parent, 0);
        middle.setLayoutData((Object)new GridData(1808));
        middle.setLayout((Layout)new GridLayout(3, false));
        Label spacer = new Label(middle, 0);
        GridData gd = new GridData();
        gd.widthHint = 10;
        spacer.setLayoutData((Object)gd);
        Composite center = new Composite(middle, 0);
        gd = new GridData(1808);
        center.setLayoutData((Object)gd);
        center.setLayout((Layout)new GridLayout(1, true));
        spacer = new Label(middle, 0);
        gd = new GridData();
        gd.widthHint = 10;
        spacer.setLayoutData((Object)gd);
        Group howItWorks = new Group(center, 0);
        howItWorks.setText(Messages.AiExplainedDialog_group);
        howItWorks.setLayoutData((Object)new GridData(1808));
        howItWorks.setLayout((Layout)new GridLayout(3, false));
        Text text = new Text((Composite)howItWorks, 586);
        text.setLayoutData((Object)new GridData(1808));
        text.setEditable(false);
        String content = Messages.AiExplainedDialog_content;
        text.setText(content);
        Activator.addAccessibilityData((Control)text, text.getText(), null);
        if (this.modelId != null) {
            Label label = new Label(center, 1);
            label.setText(Messages.AiExplainedDialog_model_label);
            label.setLayoutData((Object)new GridData());
            String url = modelLinks.getOrDefault(this.modelId, "https://www.ibm.com/docs/en/watsonx/watsonx-code-assistant-4z/2.x?topic=welcome-generative-ai-in-watsonx-code-assistant-z");
            if (url != null) {
                Link modelLink = new Link(center, 0);
                modelLink.setText("<a>" + this.modelId + "</a>");
                modelLink.setLayoutData((Object)new GridData());
                modelLink.addListener(13, e -> {
                    try {
                        Desktop.getDesktop().browse(new URI(url));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
            } else {
                text = new Text(center, 8);
                text.setLayoutData((Object)new GridData());
                text.setText(this.modelId);
            }
            label = new Label(center, 1);
            label.setText(Messages.AiExplainedDialog_model_details_label);
            label.setLayoutData((Object)new GridData());
            text = new Text(center, 586);
            gd = new GridData(1808);
            gd.widthHint = 200;
            text.setLayoutData((Object)gd);
            text.setEditable(false);
            text.setText(Messages.AiExplainedDialog_model_description);
        }
        return middle;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 1) {
            button.setVisible(false);
        }
        return button;
    }

    protected boolean isResizable() {
        return true;
    }
}

