/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.api.explanations;

import com.ibm.systemz.wcaz4e.Messages;
import com.ibm.systemz.wcaz4e.api.IApiError;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class ExplanationsError
implements IApiError {
    public String error_description;
    public String trace;
    public Error[] errors;

    private IStatus getErrorStatus(Error error) {
        if (error != null && error.code != null && error.message != null) {
            String codePlusMessage = MessageFormat.format(Messages.ExplanationsError_messageCodeAndTitle, error.code, error.message);
            int severity = this.getSeverity(error.code);
            if (error.more_info != null && !error.more_info.isBlank()) {
                Status moreInfo = new Status(severity, "com.ibm.systemz.wcaz4e", error.more_info);
                return new MultiStatus("com.ibm.systemz.wcaz4e", severity, new IStatus[]{moreInfo}, codePlusMessage, null);
            }
            return new Status(severity, "com.ibm.systemz.wcaz4e", codePlusMessage);
        }
        return null;
    }

    @Override
    public IStatus getStatus() {
        if (this.errors != null && this.errors.length > 0) {
            return this.getErrorStatus(this.errors[0]);
        }
        return new Status(this.getSeverity(this.trace), "com.ibm.systemz.wcaz4e", this.error_description);
    }

    @Override
    public void logRedactedStatuses() {
        Status rootStatus = new Status(this.getSeverity(this.trace), "com.ibm.systemz.wcaz4e", this.error_description);
        StatusManager.getManager().handle((IStatus)rootStatus, 1);
        int i = 1;
        while (i < this.errors.length) {
            IStatus errorStatus = this.getErrorStatus(this.errors[i]);
            if (errorStatus != null) {
                StatusManager.getManager().handle(errorStatus, 1);
            }
            ++i;
        }
    }

    public class Error {
        public String code;
        public String message;
        public String more_info;
    }
}

