/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.api.explanations;

import com.ibm.systemz.wcaz4e.Activator;
import com.ibm.systemz.wcaz4e.api.ApiClient;
import com.ibm.systemz.wcaz4e.api.ApiClientException;
import com.ibm.systemz.wcaz4e.api.explanations.ExplanationsError;
import com.ibm.systemz.wcaz4e.api.explanations.ExplanationsPostRequest;
import com.ibm.systemz.wcaz4e.api.explanations.ExplanationsPostResponse;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.eclipse.core.runtime.IProgressMonitor;

public class Explanations {
    ApiClient client;

    public Explanations(ApiClient client) {
        this.client = client;
    }

    public ExplanationsPostResponse post(ExplanationsPostRequest request, LANGUAGE language, LEVEL level, IProgressMonitor monitor) throws ApiClientException {
        String jsonBody = this.client.gson().toJson((Object)request);
        String path = MessageFormat.format("/v1/wca/code/explanation/{0}?level={1}", language.toString(), level.toString());
        HttpPost method = new HttpPost(this.client.getEndpoint() + path);
        method.setHeader("User-Agent", (Object)Activator.getInstance().getUserAgent());
        String acceptLang = Locale.getDefault().getLanguage();
        if (acceptLang == null || acceptLang.length() == 0) {
            acceptLang = Locale.ENGLISH.getLanguage();
        }
        method.setHeader("Accept-Language", (Object)acceptLang);
        if (Boolean.parseBoolean(System.getenv("WCA4Z_EXPLANATION_DISABLE_SSL"))) {
            this.client.setDisableCertificateValidation(true);
        }
        ExplanationsPostResponse response = (ExplanationsPostResponse)this.client.execute((HttpUriRequestBase)method, jsonBody, ExplanationsPostResponse.class, ExplanationsError.class, monitor);
        return response;
    }

    public static enum LANGUAGE {
        COBOL,
        JCL,
        PL1,
        REXX,
        HLASM;

    }

    public static enum LEVEL {
        SIMPLE,
        DETAILED,
        GUIDED;

    }
}

