/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.api;

import com.ibm.systemz.wcaz4e.Messages;
import com.ibm.systemz.wcaz4e.Tracer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMonitorCancellationThread
implements Runnable {
    private Thread worker;
    private int interval = 1000;
    IProgressMonitor monitor;
    HttpUriRequestBase request;
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);

    public ProgressMonitorCancellationThread(HttpUriRequestBase request, IProgressMonitor monitor) {
        this.request = request;
        this.monitor = monitor;
    }

    public void start() {
        this.worker = new Thread(this);
        this.worker.setName(Messages.ProgressMonitorCancellationThread_thread_name);
        this.worker.start();
    }

    public void stop() {
        this.stopRequested.set(true);
    }

    @Override
    public void run() {
        Tracer.trace().trace("/debug/api", "Starting: " + this.request.getRequestUri());
        while (!this.stopRequested.get()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                this.stop();
            }
            if (!this.monitor.isCanceled()) continue;
            Tracer.trace().trace("/debug/api", "Cancellation detected, aborting request");
            this.request.abort();
            this.stop();
        }
        Tracer.trace().trace("/debug/api", "Exiting: " + this.request.getRequestUri());
    }
}

