/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.api;

import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.security.CloudPakForDataAuthenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.preferences.PreferenceUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Locale;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class ApiManager {
    private static ApiManager instance;
    private Map<String, BaseService> clientServiceInstances = new HashMap<String, BaseService>();
    private String apikey;
    private com.ibm.cloud.sdk.core.security.Authenticator authenticator;
    private URL watsonxAPIUrl;
    private URL watsonxIAMAuthUrl;
    private String authenticationType;
    private boolean strictSSL;
    private int timeout;

    private ApiManager() {
    }

    public static synchronized ApiManager getInstance() {
        if (instance == null) {
            instance = new ApiManager();
        }
        return instance;
    }

    public static <T extends BaseService> T getServiceInstance(String clientId, Class<T> type) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, MalformedURLException, InvalidPropertiesFormatException {
        Object service = ApiManager.checkAndRefreshExistingInstance(clientId, type.getTypeName());
        if (type.isInstance(service)) {
            Tracer.trace().trace("/debug", MessageFormat.format("A plugin with id {0} re-requested its existing Cloud SDK service instance via the ApiManager.", clientId));
            return service;
        }
        Tracer.trace().trace("/debug", MessageFormat.format("A plugin with id {0} requested an Cloud SDK service instance via the ApiManager.", clientId));
        ApiManager.configurePrivateFields();
        service = (BaseService)type.getConstructor(String.class, com.ibm.cloud.sdk.core.security.Authenticator.class).newInstance(ApiManager.createMapKey(clientId, type.getTypeName()), ApiManager.getInstance().authenticator);
        ApiManager.setCloudSdkOptions(service, clientId);
        ApiManager.getInstance().clientServiceInstances.put(ApiManager.createMapKey(clientId, type.getTypeName()), (BaseService)service);
        return service;
    }

    private static <T extends BaseService> void setCloudSdkOptions(T service, String clientId) {
        service.setDefaultHeaders(Map.of("user-agent", clientId, "accept-language", Locale.getDefault().getLanguage()));
        service.setServiceUrl(ApiManager.getInstance().watsonxAPIUrl.toExternalForm());
        HttpConfigOptions.Builder optionsBuilder = new HttpConfigOptions.Builder();
        optionsBuilder.disableSslVerification(!ApiManager.getInstance().strictSSL);
        ApiManager.setProxyConfiguration(optionsBuilder);
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder(service.getClient());
        clientBuilder.callTimeout(Duration.ofMillis(PreferenceUtil.getRequestTimeoutMs()));
        Tracer.trace().trace("/trace", MessageFormat.format("\tserviceUrl - {0}\n\tdefaultHeaders - {1}\n\tauthenticationType - {2}", service.getServiceUrl(), service.getDefaultHeaders(), service.getAuthenticator()));
        service.setClient(clientBuilder.build());
        service.configureClient(optionsBuilder.build());
    }

    private static void setProxyConfiguration(HttpConfigOptions.Builder optionsBuilder) {
        String httpProxyHost = System.getProperty("http.proxyHost");
        String httpProxyPort = System.getProperty("http.proxyPort");
        final String httpProxyUser = System.getProperty("http.proxyUser");
        final String httpProxyPassword = System.getProperty("http.proxyPassword");
        if (httpProxyHost != null && httpProxyPort != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, Integer.parseInt(httpProxyPort)));
            Authenticator proxyAuthenticator = null;
            if (httpProxyUser != null && httpProxyPassword != null) {
                proxyAuthenticator = new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        String credential = Credentials.basic((String)httpProxyUser, (String)httpProxyPassword);
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
            }
            optionsBuilder.proxy(proxy).proxyAuthenticator(proxyAuthenticator).build();
        }
    }

    private static void configurePrivateFields() throws InvalidPropertiesFormatException, MalformedURLException {
        ApiManager instance = ApiManager.getInstance();
        instance.watsonxAPIUrl = new URL(PreferenceUtil.getWcazUrl());
        instance.authenticationType = PreferenceUtil.getPlatform();
        instance.strictSSL = PreferenceUtil.getStrictSSL() && !Boolean.parseBoolean(System.getenv("WCA4Z_EXPLANATION_DISABLE_SSL"));
        instance.timeout = PreferenceUtil.getRequestTimeoutMs();
        instance.apikey = new String(PreferenceUtil.getApiKey());
        instance.watsonxIAMAuthUrl = new URL(PreferenceUtil.getAuthenticationUrl());
        if (instance.authenticationType.equals("IBM Cloud") && !PreferenceUtil.isApiKeyMissing()) {
            instance.authenticator = new IamAuthenticator.Builder().url(instance.watsonxIAMAuthUrl.getRef()).apikey(instance.apikey).disableSSLVerification(!instance.strictSSL).build();
        } else if (instance.authenticationType.equals("IBM Cloud Pak for Data")) {
            String username = new String(PreferenceUtil.getUsername());
            if (username.isBlank()) {
                throw new InvalidPropertiesFormatException("WCAZEC0001E: Missing Api Key");
            }
            instance.authenticator = new CloudPakForDataAuthenticator.Builder().username(username).apikey(instance.apikey).url(instance.watsonxIAMAuthUrl.toExternalForm()).disableSSLVerification(!instance.strictSSL).build();
        } else {
            throw new Error("WCZEC0011E Internal error: ApiManager called with invalid parameters.");
        }
        if (instance.authenticator == null) {
            throw new Error("WCZEC0012E Internal error: Authenticator not initiallized.");
        }
    }

    private static <T extends BaseService> T checkAndRefreshExistingInstance(String clientId, String typeName) throws MalformedURLException, InvalidPropertiesFormatException {
        String apikey = new String(PreferenceUtil.getApiKey());
        ApiManager.getInstance().authenticationType = PreferenceUtil.getPlatform();
        if (apikey == null || apikey.isEmpty()) {
            throw new InvalidPropertiesFormatException("WCAZEC0001E: Missing Api Key");
        }
        BaseService serviceInstance = null;
        if (clientId != null && typeName != null) {
            serviceInstance = ApiManager.getInstance().clientServiceInstances.get(ApiManager.createMapKey(clientId, typeName));
        }
        com.ibm.cloud.sdk.core.security.Authenticator auth = ApiManager.getInstance().authenticator;
        if (ApiManager.checkSettingsChange(serviceInstance)) {
            return null;
        }
        if (apikey.equals(ApiManager.getInstance().apikey) && serviceInstance != null) {
            if (auth instanceof IamAuthenticator && ((IamAuthenticator)auth).getToken() != null) {
                return (T)serviceInstance;
            }
            if (auth instanceof CloudPakForDataAuthenticator) {
                auth.validate();
                return (T)serviceInstance;
            }
        }
        return null;
    }

    private static String createMapKey(String clientId, String typeName) {
        return String.format("%s-%s", clientId, typeName);
    }

    private static boolean checkSettingsChange(BaseService serviceInstance) throws MalformedURLException {
        if (!(serviceInstance == null || ApiManager.getInstance().watsonxAPIUrl.equals(new URL(PreferenceUtil.getWcazUrl())) && ApiManager.getInstance().timeout == PreferenceUtil.getRequestTimeoutMs())) {
            Tracer.trace().trace("/debug", MessageFormat.format("Service {0} has been updated through the ApiManager", serviceInstance.getName()));
            return true;
        }
        return false;
    }
}

