/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e.api;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.api.ApiClientAuthenticationException;
import com.ibm.systemz.wcaz4e.api.ApiClientException;
import com.ibm.systemz.wcaz4e.api.HttpError;
import com.ibm.systemz.wcaz4e.api.IApiError;
import com.ibm.systemz.wcaz4e.api.IAuthenticationErrorHandler;
import com.ibm.systemz.wcaz4e.preferences.PreferenceUtil;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class ApiClient {
    private String token = null;
    private String endpoint = null;
    private boolean disableCertificateValidation = false;
    private boolean useRseCertificateStore = false;
    private Gson gson = new Gson();
    private String hostnameVerificationPreferenceId;
    private IPreferenceStore hostnameVerificationPreferenceStore;
    private String connectionName;
    private IAuthenticationErrorHandler authErrorHandler = null;
    private CloseableHttpClient httpClient;

    public ApiClient(String connectionName, IPreferenceStore preferenceStore, String preferenceId) {
        this.hostnameVerificationPreferenceStore = preferenceStore;
        this.hostnameVerificationPreferenceId = preferenceId;
        this.connectionName = connectionName;
    }

    public ApiClient() {
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setAuthenticationErrorHandler(IAuthenticationErrorHandler authErrorHandler) {
        this.authErrorHandler = authErrorHandler;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setDisableCertificateValidation(boolean disable) {
        this.disableCertificateValidation = disable;
    }

    public void setUseRseCertificateStore(boolean useRseCertificateStore) {
        this.useRseCertificateStore = useRseCertificateStore;
    }

    public Gson gson() {
        return this.gson;
    }

    public HttpClient getClient() {
        if (this.httpClient == null) {
            try {
                SSLConnectionSocketFactory sslSocketFactory;
                if (this.disableCertificateValidation) {
                    Tracer.trace().trace("/debug/api", "Creating HttpClient that accepts all certificates as trusted.");
                    SSLContextBuilder builder = new SSLContextBuilder();
                    builder.loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE);
                    sslSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                } else {
                    sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(new TLS[]{TLS.V_1_3}).build();
                }
                SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)PreferenceUtil.getRequestTimeoutMs())).build();
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)PreferenceUtil.getRequestTimeoutMs())).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)PreferenceUtil.getRequestTimeoutMs())).setResponseTimeout(Timeout.ofMilliseconds((long)PreferenceUtil.getRequestTimeoutMs())).build();
                PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultSocketConfig(socketConfig).setConnectionTimeToLive(TimeValue.ofMilliseconds((long)PreferenceUtil.getRequestTimeoutMs())).build();
                this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.httpClient;
    }

    public void close() {
        if (this.httpClient != null) {
            try {
                Tracer.trace().trace("/debug/api", "Closing client");
                this.httpClient.close();
            }
            catch (IOException e) {
                Tracer.trace().trace("/debug/api", "Error closing client", (Throwable)e);
                e.printStackTrace();
            }
        }
        this.httpClient = null;
        this.token = null;
    }

    public Object execute(HttpUriRequestBase request, String payload, Class<?> responseClass, Class<?> errorClass, IProgressMonitor monitor) throws ApiClientException {
        return this.execute(request, payload, responseClass, errorClass, monitor, null);
    }

    /*
     * Exception decompiling
     */
    public Object execute(HttpUriRequestBase request, String payload, Class<?> responseClass, Class<?> errorClass, IProgressMonitor monitor, String maskedPayload) throws ApiClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object parseResponse(HttpResponse response, Class<?> responseClass, Class<?> errorClass) throws ApiClientException {
        Object result = null;
        ApiClientException exception = null;
        int statusCode = response.getCode();
        Tracer.trace().trace("/debug/api", "Response Code: " + statusCode);
        Header[] headerArray = response.getHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            Tracer.trace().trace("/debug/api", header.getName() + ": " + header.getValue());
            ++n2;
        }
        if (response instanceof CloseableHttpResponse) {
            HttpEntity entity = ((CloseableHttpResponse)response).getEntity();
            try {
                result = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (ParseException e) {
                exception = new ApiClientException(e);
            }
            catch (IOException e) {
                exception = new ApiClientException(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        Tracer.trace().trace("/debug/api", "Result body: " + result.toString());
        if (200 <= statusCode && 300 > statusCode) {
            if (responseClass != null) {
                result = this.gson.fromJson((String)result, responseClass);
            }
        } else {
            IApiError error = null;
            try {
                if (result != null) {
                    error = (IApiError)this.gson.fromJson((String)result, errorClass);
                }
            }
            catch (JsonSyntaxException jse) {
                Tracer.trace().trace("/debug/api", "Non-standard json error response", (Throwable)jse);
                error = new HttpError(statusCode, response.getReasonPhrase(), result.toString());
            }
            if (error != null && response.getCode() == 401) {
                throw new ApiClientAuthenticationException(error);
            }
            throw new ApiClientException(error);
        }
        return result;
    }
}

