/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e;

import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.actions.Command;
import com.ibm.systemz.wcaz4e.explanation.CodeExplanationView;
import com.ibm.systemz.wcaz4e.languages.LanguageTester;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;

public class WcazPropertyTester
extends PropertyTester {
    static final String EXPLANATION_ACTIVITY = "com.ibm.systemz.wcaz4e.activities.explanation";
    static boolean wasCodeExplainEnabled = false;

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        return WcazPropertyTester.test(receiver, property);
    }

    public static boolean isCodeExplanationEnabled() {
        if (PlatformUI.isWorkbenchRunning()) {
            wasCodeExplainEnabled = PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getActivity(EXPLANATION_ACTIVITY).isEnabled();
        }
        return wasCodeExplainEnabled;
    }

    public static boolean isRegenerateCommandEnabled(PROPERTIES property) {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                if ("com.ibm.systemz.wcaz4e.explanation.CodeExplanationView".equals(viewReference.getId())) {
                    IViewPart part = viewReference.getView(false);
                    if (part == null || !(part instanceof CodeExplanationView)) break;
                    switch (property) {
                        case canRegenerateSimple: {
                            return ((CodeExplanationView)part).isRegenerateCommandEnabled(Command.SIMPLE);
                        }
                        case canRegenerateDetailed: {
                            return ((CodeExplanationView)part).isRegenerateCommandEnabled(Command.DETAILED);
                        }
                        case canRegenerateGuided: {
                            return ((CodeExplanationView)part).isRegenerateCommandEnabled(Command.GUIDED);
                        }
                    }
                    break;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void registerActivityListener() {
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(new IActivityManagerListener(){

            public void activityManagerChanged(ActivityManagerEvent event) {
                WcazPropertyTester.isCodeExplanationEnabled();
            }
        });
    }

    public static boolean test(Object receiver, String propertyName) {
        boolean result = false;
        try {
            PROPERTIES property = PROPERTIES.valueOf(propertyName);
            switch (property) {
                case saasPlatformSelected: {
                    result = LanguageTester.isSaasPlatformSelected();
                    break;
                }
                case codeExplainEnabled: {
                    result = WcazPropertyTester.isCodeExplanationEnabled();
                    break;
                }
                case canRegenerateSimple: 
                case canRegenerateDetailed: 
                case canRegenerateGuided: {
                    result = WcazPropertyTester.isRegenerateCommandEnabled(property);
                    break;
                }
                case canExplainAny: {
                    result = !LanguageTester.getActiveCommands(receiver).isEmpty();
                    break;
                }
                case canExplainSimple: {
                    result = LanguageTester.getActiveCommands(receiver).contains((Object)Command.SIMPLE);
                    break;
                }
                case canExplainDetailed: {
                    result = LanguageTester.getActiveCommands(receiver).contains((Object)Command.DETAILED);
                    break;
                }
                case canExplainGuided: {
                    result = LanguageTester.getActiveCommands(receiver).contains((Object)Command.GUIDED);
                    break;
                }
                case explorerSelectionEnabled: {
                    result = LanguageTester.explorerSelectionEnabled(receiver);
                    break;
                }
                case isSimpleEnabled: {
                    result = LanguageTester.isSimpleEnabled(receiver);
                    break;
                }
                case isDetailedEnabled: {
                    result = LanguageTester.isDetailedEnabled(receiver);
                    break;
                }
                case isGuidedEnabled: {
                    result = LanguageTester.isGuidedEnabled(receiver);
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Tracer.trace().trace("/debug", "unknown propertyName \"" + propertyName);
        }
        Tracer.trace().trace("/debug", "Property " + propertyName + ": " + result);
        return result;
    }

    public static enum PROPERTIES {
        codeExplainEnabled,
        canExplainAny,
        canExplainSimple,
        canExplainDetailed,
        canExplainGuided,
        canRegenerateSimple,
        canRegenerateDetailed,
        canRegenerateGuided,
        explorerSelectionEnabled,
        isSimpleEnabled,
        isDetailedEnabled,
        isGuidedEnabled,
        saasPlatformSelected;

    }
}

