/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.systemz.wcaz4e;

import com.ibm.systemz.wcaz4e.Images;
import com.ibm.systemz.wcaz4e.Messages;
import com.ibm.systemz.wcaz4e.Tracer;
import com.ibm.systemz.wcaz4e.extensionpoint.ExtensionManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class Activator
extends AbstractUIPlugin {
    public static final String kPluginID = "com.ibm.systemz.wcaz4e";
    protected static Activator sPlugin;
    private ScopedPreferenceStore preferenceStore;
    private String userAgent;
    private ExtensionManager extensionManager;

    public static Activator getInstance() {
        if (sPlugin == null) {
            new Activator();
        }
        return sPlugin;
    }

    public Activator() {
        sPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        Version bundleVersion = this.getBundle().getVersion();
        String agentName = "zCodeAssistant-eclipse";
        this.userAgent = String.format("%s/%d.%d.%d", agentName, bundleVersion.getMajor(), bundleVersion.getMinor(), bundleVersion.getMicro());
        super.start(context);
        Tracer.setup(context);
        this.extensionManager = new ExtensionManager();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        int i = 0;
        while (i < Images.imagelist.length) {
            String key = Images.imagelist[i];
            reg.put(key, this.createImageDescriptor(key));
            ++i;
        }
    }

    protected ImageDescriptor createImageDescriptor(String relativePath) {
        Optional imageDescriptor = ResourceLocator.imageDescriptorFromBundle((String)kPluginID, (String)relativePath);
        if (!imageDescriptor.isPresent()) {
            Tracer.trace().trace("/debug", "Failed to load image: " + relativePath);
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return (ImageDescriptor)imageDescriptor.get();
    }

    public static Display getDisplay() {
        return Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
    }

    public static void addAccessibilityData(Control control, final String name, final String tooltip) {
        control.getAccessible().addAccessibleListener(new AccessibleListener(){

            public void getDescription(AccessibleEvent arg0) {
                if (SystemUtils.IS_OS_MAC) {
                    Control c;
                    arg0.result = name;
                    if (arg0.getSource() instanceof Accessible && (c = ((Accessible)arg0.getSource()).getControl()).getParent() instanceof Group) {
                        arg0.result = MessageFormat.format(Messages.Accessibility_OSMAC_GROUPNAME_CONTROLNAME, ((Group)c.getParent()).getText(), name);
                    }
                } else {
                    arg0.result = tooltip;
                }
            }

            public void getHelp(AccessibleEvent arg0) {
                arg0.result = SystemUtils.IS_OS_MAC ? tooltip : null;
            }

            public void getKeyboardShortcut(AccessibleEvent arg0) {
                arg0.result = null;
            }

            public void getName(AccessibleEvent arg0) {
                arg0.result = SystemUtils.IS_OS_MAC ? null : name;
            }
        });
    }

    public File getBundleFile(String bundlePath) throws IOException, URISyntaxException {
        Tracer.trace().trace("/debug", "getBundleFile(): " + bundlePath);
        URL pathUrl = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(bundlePath));
        Tracer.trace().trace("/debug", "pathUrl: " + String.valueOf(pathUrl));
        URL fileUrl = FileLocator.toFileURL((URL)pathUrl);
        Tracer.trace().trace("/debug", "fileUrl: " + String.valueOf(fileUrl));
        URI fileUri = new URI(fileUrl.getProtocol(), fileUrl.getPath(), null);
        Tracer.trace().trace("/debug", "fileUri: " + String.valueOf(fileUri));
        return new File(fileUri);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public static Activator getDefault() {
        return sPlugin;
    }

    public static void logInfo(String message) {
        ILog log = Activator.getDefault().getLog();
        log.log((IStatus)new Status(1, kPluginID, message));
    }
}

