/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import net.oauth.client.ExcerptInputStream;
import net.oauth.client.httpclient4.HttpClientPool;
import net.oauth.client.httpclient4.HttpMethodResponse;
import net.oauth.http.HttpClient;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;

public class HttpClient4
implements HttpClient {
    private final HttpClientPool clientPool;
    private static final HttpClientPool SHARED_CLIENT = new SingleClient();

    public HttpClient4() {
        this(SHARED_CLIENT);
    }

    public HttpClient4(HttpClientPool clientPool) {
        this.clientPool = clientPool;
    }

    @Override
    public HttpResponseMessage execute(HttpMessage request) throws IOException {
        Object httpRequest;
        String method = request.method;
        String url = request.url.toExternalForm();
        InputStream body = request.getBody();
        boolean isDelete = "DELETE".equalsIgnoreCase(method);
        boolean isPost = "POST".equalsIgnoreCase(method);
        boolean isPut = "PUT".equalsIgnoreCase(method);
        byte[] excerpt = null;
        if (isPost || isPut) {
            HttpPost httpPost;
            Object object = httpPost = isPost ? new HttpPost(url) : new HttpPut(url);
            if (body != null) {
                ExcerptInputStream e = new ExcerptInputStream(body);
                excerpt = e.getExcerpt();
                String length = request.removeHeaders("Content-Length");
                httpPost.setEntity((HttpEntity)new InputStreamEntity((InputStream)e, length == null ? -1L : Long.parseLong(length)));
            }
            httpRequest = httpPost;
        } else {
            httpRequest = isDelete ? new HttpDelete(url) : new HttpGet(url);
        }
        for (Map.Entry entry : request.headers) {
            httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        org.apache.http.client.HttpClient httpClient = this.clientPool.getHttpClient(new URL(httpRequest.getURI().toString()));
        httpClient.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
        return new HttpMethodResponse((HttpRequestBase)httpRequest, httpResponse, excerpt, request.getContentCharset());
    }

    private static class SingleClient
    implements HttpClientPool {
        private final org.apache.http.client.HttpClient client;

        SingleClient() {
            DefaultHttpClient client = new DefaultHttpClient();
            ClientConnectionManager mgr = client.getConnectionManager();
            if (!(mgr instanceof ThreadSafeClientConnManager)) {
                HttpParams params = client.getParams();
                client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(params, mgr.getSchemeRegistry()), params);
            }
            this.client = client;
        }

        @Override
        public org.apache.http.client.HttpClient getHttpClient(URL server) {
            return this.client;
        }
    }
}

