/*
 * Decompiled with CFR 0.152.
 */
package javax.wvcm;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.wvcm.Provider;
import javax.wvcm.WvcmException;

public final class ProviderFactory {
    private ProviderFactory() {
    }

    public static Provider createProvider(String providerName, Callback callback) throws Exception {
        try {
            return (Provider)Class.forName(providerName).getConstructor(Callback.class).newInstance(callback);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof WvcmException) {
                throw (WvcmException)cause;
            }
            throw ex;
        }
    }

    public static Provider createProvider(String providerName, Callback callback, Map<String, String> initArgs) throws Exception {
        try {
            return (Provider)Class.forName(providerName).getConstructor(Callback.class, Map.class).newInstance(callback, initArgs);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof WvcmException) {
                throw (WvcmException)cause;
            }
            throw ex;
        }
    }

    public static interface Callback {
        public Authentication getAuthentication(String var1, int var2) throws WvcmException;

        public static interface Authentication {
            public String loginName();

            public String password();
        }
    }
}

