/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui.wizards.creation;

import com.ibm.team.enterprise.common.client.util.ZComponentUtils;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataSetDefinitionSelectionDialog;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.internal.zcomponent.ui.nls.Messages;
import com.ibm.teamz.internal.zcomponent.ui.wizards.creation.NewFolderWizard;
import com.ibm.teamz.internal.zcomponent.ui.wizards.creation.ZComponentIResourceLabelProvider;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NewFolderFirstPage
extends WizardPage {
    Text projectNameField;
    Text containerNameField;
    Text fDataSetDefinitonField;
    String fDataSetDefinitionUUID;
    private final Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = NewFolderFirstPage.this.validatePage();
            NewFolderFirstPage.this.setPageComplete(valid);
        }
    };
    private final Listener containerNameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = NewFolderFirstPage.this.validatePage();
            NewFolderFirstPage.this.setPageComplete(valid);
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public NewFolderFirstPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.build.ui.wizard_zfolder");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite subGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        subGroup.setLayout((Layout)layout);
        subGroup.setLayoutData((Object)new GridData(768));
        this.createProjectNameGroup(subGroup);
        this.createContainerNameGroup(subGroup);
        this.createDataDefinitionGroup(subGroup);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectNameGroup(Composite subGroup) {
        Label projectLabel = new Label(subGroup, 0);
        projectLabel.setText(Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_LABEL);
        projectLabel.setFont(subGroup.getFont());
        this.projectNameField = new Text(subGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(subGroup.getFont());
        IStructuredSelection selection = ((NewFolderWizard)this.getWizard()).selection;
        if (selection != null && !selection.isEmpty()) {
            IFile file;
            IProject project;
            String projectName;
            Object context = selection.getFirstElement();
            if (context instanceof IProject) {
                IProject project2 = (IProject)context;
                String projectName2 = project2.getName();
                if (ZComponentUtils.isZComponentProject((String)projectName2)) {
                    this.projectNameField.setText(projectName2.trim());
                }
            } else if (context instanceof IFolder) {
                IFolder folder = (IFolder)context;
                IProject project3 = folder.getProject();
                String projectName3 = project3.getName();
                if (ZComponentUtils.isZComponentProject((String)projectName3)) {
                    this.projectNameField.setText(projectName3.trim());
                }
            } else if (context instanceof IFile && ZComponentUtils.isZComponentProject((String)(projectName = (project = (file = (IFile)context).getProject()).getName()))) {
                this.projectNameField.setText(projectName.trim());
            }
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
        Button button = new Button(subGroup, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(NewFolderFirstPage.this.getShell(), (ILabelProvider)new ZComponentIResourceLabelProvider());
                dialog.setIgnoreCase(false);
                dialog.setTitle(Messages.BUILDZ_PROJECT_SELECTION_LABEL);
                dialog.setMessage(Messages.BUILDZ_PROJECT_SELECTION_DESCRIPTION);
                dialog.setEmptyListMessage(Messages.BUILDZ_PROJECT_SELECTION_EMPTY);
                dialog.setMultipleSelection(false);
                dialog.setElements((Object[])ZComponentUtils.getZComponentProjects());
                dialog.open();
                Object result = dialog.getFirstResult();
                if (result != null) {
                    NewFolderFirstPage.this.projectNameField.setText(((IProject)result).getName());
                }
            }
        });
        button.setText(Messages.BUILDZ_SELECTION_BUTTON_LABEL);
    }

    private final void createContainerNameGroup(Composite subGroup) {
        Label containerLabel = new Label(subGroup, 0);
        containerLabel.setText(Messages.BUILDZ_ZFOLDER_WIZARD_ZFOLDER_NAME_LABEL);
        containerLabel.setFont(subGroup.getFont());
        this.containerNameField = new Text(subGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.containerNameField.setLayoutData((Object)data);
        this.containerNameField.setFont(subGroup.getFont());
        this.containerNameField.addListener(24, this.containerNameModifyListener);
        Label filler = new Label(subGroup, 0);
        filler.setText("");
    }

    private final void createDataDefinitionGroup(Composite subGroup) {
        Label label = new Label(subGroup, 0);
        label.setText(Messages.BUILDZ_ZFOLDER_WIZARD_DATA_DEFINITION_LABEL);
        this.fDataSetDefinitonField = new Text(subGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fDataSetDefinitonField.setLayoutData((Object)data);
        this.fDataSetDefinitonField.setFont(subGroup.getFont());
        this.fDataSetDefinitonField.setEditable(false);
        Button button = new Button(subGroup, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ISystemDefinition dataset;
                    DataSetDefinitionSelectionDialog dialog;
                    IProject project = null;
                    IShareable share = null;
                    ITeamRepository repo = null;
                    boolean isProblem = false;
                    if (NewFolderFirstPage.this.getNameFieldValue(NewFolderFirstPage.this.projectNameField) != null) {
                        project = ZComponentUtils.getProject((String)NewFolderFirstPage.this.getNameFieldValue(NewFolderFirstPage.this.projectNameField));
                        share = (IShareable)project.getAdapter(IShareable.class);
                        if (share == null || !ZComponentUtils.isShared((IProject)project)) {
                            NewFolderFirstPage.this.setMessage(Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_NOT_SHARED_WARNING, 1);
                            isProblem = true;
                        } else {
                            repo = ZComponentUtils.getTeamRepository((IShareable)share);
                            if (repo == null || !repo.loggedIn()) {
                                NewFolderFirstPage.this.setMessage(Messages.BUILDZ_ZFOLDER_WIZARD_NOT_LOGGED_IN_TO_REPOSITORY_WARNING, 1);
                                isProblem = true;
                            }
                        }
                    }
                    if (!isProblem && (dialog = new DataSetDefinitionSelectionDialog(NewFolderFirstPage.this.getShell(), repo, null, NewFolderFirstPage.this.getDataSetDefFilter(), null, true, null)).open() == 0 && (dataset = dialog.getSelectedSystemDefinition()) != null) {
                        NewFolderFirstPage.this.fDataSetDefinitionUUID = dataset.getItemId().getUuidValue();
                        NewFolderFirstPage.this.fDataSetDefinitonField.setText(dataset.getName());
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        });
        button.setText(Messages.BUILDZ_SELECTION_BUTTON_LABEL);
    }

    public String getContainerName() {
        return this.getContainerNameFieldValue();
    }

    public String getProjectName() {
        return this.getProjectNameFieldValue();
    }

    public void setProjectName(String name) {
        this.projectNameField.setText(name.trim());
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getContainerNameFieldValue() {
        if (this.containerNameField == null) {
            return "";
        }
        return this.containerNameField.getText().trim();
    }

    protected boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        String containerFieldContents = this.getContainerNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_EMPTY);
            return false;
        }
        if (containerFieldContents.equals("")) {
            this.setErrorMessage(Messages.BUILDZ_ZFOLDER_WIZARD_ZFOLDER_NAME_EMPTY);
            return false;
        }
        IProject project = this.getProjectHandle();
        if (!project.exists()) {
            this.setErrorMessage(Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_DOES_NOT_EXIST);
            return false;
        }
        if (!ZComponentUtils.isZComponentProject((String)this.getProjectNameFieldValue())) {
            this.setErrorMessage(Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_NOT_BUILDZ);
            return false;
        }
        IStatus nameStatus = workspace.validateName(containerFieldContents, 2);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        if (containerFieldContents.indexOf(32) > -1) {
            this.setErrorMessage(Messages.INVALID_CHARACTER_SPACE_IN_ZFOLDER_NAME);
            return false;
        }
        IFolder handle = this.getProjectHandle().getFolder("zOSsrc").getFolder(this.getContainerName());
        if (handle != null && handle.exists()) {
            this.setErrorMessage(Messages.BUILDZ_ZFOLDER_WIZARD_ZFOLDER_ALREADY_EXISTS);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private String getNameFieldValue(Text field) {
        if (field == null) {
            return "";
        }
        return field.getText().trim();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.containerNameField.setFocus();
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.fDataSetDefinitionUUID != null) {
            props.put("team.enterprise.resource.definition", this.fDataSetDefinitionUUID);
        }
        return props;
    }

    private ViewerFilter getDataSetDefFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IDataSetDefinition) {
                    IDataSetDefinition dsd = (IDataSetDefinition)element;
                    return dsd.getUsageType() == 0;
                }
                return true;
            }
        };
    }
}

